/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.util.CharBuffer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineMap
implements Serializable {
    private String _dstFilename;
    private String _srcFilename;
    private String _lastSrcFilename;
    private ArrayList<Line> _lines = new ArrayList();

    public LineMap() {
    }

    public LineMap(String dstFilename, String srcFilename) {
        int tail = dstFilename.lastIndexOf(47);
        if (tail < 0) {
            this._dstFilename = dstFilename;
        } else {
            dstFilename = dstFilename.substring(tail + 1);
        }
        this._srcFilename = srcFilename;
        this._lastSrcFilename = srcFilename;
    }

    public LineMap(String dstFilename) {
        int tail = dstFilename.lastIndexOf(47);
        this._dstFilename = tail < 0 ? dstFilename : dstFilename.substring(tail + 1);
    }

    public String getDestFilename() {
        return this._dstFilename;
    }

    public boolean add(String srcFilename, int srcLine, int dstLine) {
        this._lastSrcFilename = srcFilename;
        if (this._lines.size() > 1) {
            Line prev = this._lines.get(this._lines.size() - 2);
            Line last = this._lines.get(this._lines.size() - 1);
            if ((last._srcFilename == srcFilename || last._srcFilename != null && last._srcFilename.equals(srcFilename)) && (prev._srcFilename == last._srcFilename || last._srcFilename != null && last._srcFilename.equals(prev._srcFilename)) && last._srcLine - prev._srcLine == last._destLine - prev._destLine && last._srcLine - srcLine == last._destLine - dstLine) {
                this._lines.remove(this._lines.size() - 1);
            }
        }
        this._lines.add(new Line(srcFilename, srcLine, dstLine));
        return true;
    }

    public void add(int srcLine, int dstLine) {
        this.add(this._lastSrcFilename, srcLine, dstLine);
    }

    public Iterator<Line> iterator() {
        return this._lines.iterator();
    }

    public int size() {
        return this._lines.size();
    }

    public Line get(int i) {
        return this._lines.get(i);
    }

    public Line getLine(int line) {
        Line bestMap = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (map._destLine > line) break;
            bestMap = map;
        }
        return bestMap;
    }

    public String convertError(String filename, int line, int column, String message) {
        String srcFilename = null;
        int destLine = 0;
        int srcLine = 0;
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (filename != null && !filename.endsWith(this._dstFilename)) continue;
            if (map._destLine <= line) {
                srcFilename = map._srcFilename;
                destLine = map._destLine;
                srcLine = map._srcLine;
                continue;
            }
            if (srcFilename != null) break;
            srcFilename = map._srcFilename;
            srcLine = 1;
            destLine = line;
            break;
        }
        if (srcFilename != null) {
            return new StringBuffer().append(srcFilename).append(":").append(srcLine + line - destLine).append(": ").append(message).toString();
        }
        return new StringBuffer().append(filename).append(":").append(line).append(": ").append(message).toString();
    }

    public String convertLine(String filename, int line) {
        Line bestLine = this.getLine(line);
        if (bestLine != null) {
            return new StringBuffer().append(bestLine.getSourceFilename()).append(":").append(bestLine.getSourceLine(line)).toString();
        }
        return new StringBuffer().append(filename).append(":").append(line).toString();
    }

    public void printStackTrace(Throwable e, OutputStream os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            byte[] b = cb.toString().getBytes();
            try {
                os.write(b, 0, b.length);
            }
            catch (IOException e1) {}
        } else {
            System.out.println(cb);
        }
    }

    public void printStackTrace(Throwable e, PrintWriter os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            os.print(cb.toString());
        } else {
            System.out.println(cb);
        }
    }

    private CharBuffer filter(char[] array) {
        CharBuffer buf = new CharBuffer();
        CharBuffer fun = new CharBuffer();
        CharBuffer file = new CharBuffer();
        int i = 0;
        while (i < array.length) {
            int end;
            fun.clear();
            file.clear();
            int start = i;
            for (end = i; end < array.length && array[end] != '\n'; ++end) {
            }
            while (i < end && Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            if (!fun.endsWith("at")) {
                for (i = start; i < end; ++i) {
                    buf.append(array[i]);
                }
                i = end + 1;
                buf.append('\n');
                continue;
            }
            while (i < end && Character.isWhitespace(array[i])) {
                ++i;
            }
            fun.clear();
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != '(') {
                fun.append(array[i]);
                ++i;
            }
            if (i < end && array[i] == '(') {
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            int line = -1;
            if (i < end && array[i] == ':') {
                line = 0;
                ++i;
                while (i < end && array[i] >= '0' && array[i] <= '9') {
                    line = 10 * line + array[i] - 48;
                    ++i;
                }
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            buf.append("\tat ");
            buf.append(fun);
            buf.append("(");
            String dstFile = file.toString();
            if (dstFile.equals(this._dstFilename)) {
                this.convertError(buf, line);
            } else {
                buf.append(file);
                if (line > 0) {
                    buf.append(":");
                    buf.append(line);
                }
            }
            buf.append(array, i, end - i);
            buf.append('\n');
            i = end + 1;
        }
        return buf;
    }

    private void convertError(CharBuffer buf, int line) {
        String srcFilename = null;
        int destLine = 0;
        int srcLine = 0;
        int srcTailLine = Integer.MAX_VALUE;
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (map._destLine > line) {
                if (!map._srcFilename.equals(srcFilename) || map._srcLine - srcLine >= line - destLine) break;
                line = destLine;
                break;
            }
            srcFilename = map._srcFilename;
            destLine = map._destLine;
            srcLine = map._srcLine;
        }
        if (srcFilename == null) {
            srcFilename = this._lines.size() > 0 ? this._lines.get((int)0)._srcFilename : "";
        }
        buf.append(srcFilename);
        if (line >= 0) {
            buf.append(":");
            buf.append(srcLine + (line - destLine));
        }
    }

    public static class Line
    implements Serializable {
        String _srcFilename;
        int _srcLine;
        int _destLine;

        public Line() {
        }

        Line(String srcFilename, int srcLine, int destLine) {
            this._srcFilename = srcFilename;
            this._srcLine = srcLine;
            this._destLine = destLine;
        }

        public String getSourceFilename() {
            return this._srcFilename;
        }

        public int getSourceLine() {
            return this._srcLine;
        }

        public int getSourceLine(int destLine) {
            return this._srcLine + (destLine - this._destLine);
        }

        public int getDestLine() {
            return this._destLine;
        }

        public String toString() {
            return "Line[src:" + this._srcFilename + ":" + this._srcLine + ",dst:" + this._destLine + "]";
        }
    }
}

