/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;

public class WorkDir {
    private static final EnvironmentLocal<Path> _localWorkDir = new EnvironmentLocal("caucho.work-dir");
    private Path _path;

    public static Path getLocalWorkDir() {
        return WorkDir.getLocalWorkDir(Thread.currentThread().getContextClassLoader());
    }

    public static Path getLocalWorkDir(ClassLoader loader) {
        Path path = _localWorkDir.get(loader);
        if (path != null) {
            return path;
        }
        path = CauchoSystem.isWindows() ? Vfs.lookup("file:/c:/temp/caucho") : Vfs.lookup("file:/tmp/caucho");
        _localWorkDir.setGlobal(path);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static void setLocalWorkDir(Path path) {
        _localWorkDir.set(path);
    }

    public static void setLocalWorkDir(Path path, ClassLoader loader) {
        _localWorkDir.set(path, loader);
    }

    public void setId(Path path) throws IOException {
        this._path = path;
        path.mkdirs();
    }

    public void init() {
        _localWorkDir.set(this._path);
    }
}

