/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;

public class BaseMethod
extends ClassComponent {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/java/gen/BaseMethod"));
    private Method _method;
    private String _methodName;
    private boolean _isStatic;
    private String _visibility = "public";
    private Class _returnType;
    private Class[] _parameterTypes;
    private Class[] _exceptionTypes;
    private CallChain _call;

    public BaseMethod(String methodName, CallChain call) {
        this._methodName = methodName;
        this.setCall(call);
    }

    public BaseMethod(Method method, CallChain call) {
        this._method = method;
        this._exceptionTypes = method.getExceptionTypes();
        this.setCall(call);
    }

    public BaseMethod(Method method) {
        this._method = method;
        this._exceptionTypes = method.getExceptionTypes();
    }

    public BaseMethod(Method apiMethod, Method implMethod) {
        this(apiMethod, (CallChain)new MethodCallChain(implMethod));
    }

    public CallChain getCall() {
        return this._call;
    }

    public void setCall(CallChain call) {
        if (call == null) {
            throw new NullPointerException();
        }
        this._call = call;
    }

    public Method getMethod() {
        return this._method;
    }

    public String getMethodName() {
        if (this._methodName != null) {
            return this._methodName;
        }
        return this._method.getName();
    }

    public Class[] getParameterTypes() {
        if (this._parameterTypes != null) {
            return this._parameterTypes;
        }
        if (this._method != null) {
            return this._method.getParameterTypes();
        }
        return this._call.getParameterTypes();
    }

    public Class getReturnType() {
        if (this._method != null) {
            return this._method.getReturnType();
        }
        return this._call.getReturnType();
    }

    public Class[] getExceptionTypes() {
        return this._exceptionTypes;
    }

    public void generate(JavaWriter out) throws IOException {
        String[] args = this.generateMethodHeader(out);
        Class[] exceptionTypes = this.getExceptionTypes();
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            out.print("  throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.printClass(exceptionTypes[i]);
            }
            out.println();
        }
        out.println("{");
        out.pushDepth();
        this.generateCall(out, args);
        out.popDepth();
        out.println("}");
    }

    public String[] generateMethodHeader(JavaWriter out) throws IOException {
        if (this._visibility != null && !this._visibility.equals("")) {
            out.print(this._visibility + " ");
        }
        if (this._isStatic) {
            out.print("static ");
        }
        out.printClass(this.getReturnType());
        out.print(" " + this.getMethodName() + "(");
        Class[] parameterTypes = this.getParameterTypes();
        String[] args = new String[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(parameterTypes[i]);
            args[i] = "a" + i;
            out.print(" " + args[i]);
        }
        out.println(")");
        return args;
    }

    protected void generateCall(JavaWriter out, String[] args) throws IOException {
        this._call.generateCall(out, null, null, args);
    }
}

