/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.Version;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;

public class JavaClass
extends BaseClass {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/java/gen/JavaClass"));
    private String _packageName;
    private String _fullClassName;
    private ArrayList<String> _importList = new ArrayList();

    public JavaClass(String fullClassName) {
        this._fullClassName = fullClassName;
        int p = fullClassName.lastIndexOf(46);
        if (p <= 0) {
            throw new IllegalArgumentException(L.l("Class '{0}' must belong to a package.", fullClassName));
        }
        this._packageName = fullClassName.substring(0, p);
        this.setClassName(fullClassName.substring(p + 1));
    }

    public String getFullClassName() {
        return this._fullClassName;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void addImport(String importName) {
        if (!this._importList.contains(importName)) {
            this._importList.add(importName);
        }
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        if (this._packageName != null) {
            out.println();
            out.println("package " + this._packageName + ";");
        }
        if (this._importList.size() > 0) {
            out.println();
            for (int i = 0; i < this._importList.size(); ++i) {
                out.println("import " + this._importList.get(i) + ";");
            }
        }
        out.println();
        super.generate(out);
    }

    protected void generateTopComment(JavaWriter out) throws IOException {
        out.println("/*");
        out.println(" * Generated by " + Version.FULL_VERSION);
        out.println(" */");
    }
}

