/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.ConnectionPool;
import com.caucho.jca.UserPoolItem;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.jca.XAExceptionWrapper;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class PoolItem
implements ConnectionEventListener,
XAResource {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/PoolItem"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jca/PoolItem"));
    private ConnectionPool _cm;
    private ManagedConnectionFactory _mcf;
    private ManagedConnection _mConn;
    private UserTransactionImpl _transaction;
    private String _id;
    private XAResource _xaResource;
    private LocalTransaction _localTransaction;
    private int _defaultTransactionTimeout;
    private int _transactionTimeout;
    private Subject _subject;
    private ConnectionRequestInfo _requestInfo;
    private UserPoolItem _userPoolItem;
    UserPoolItem _shareHead;
    private PoolItem _xaHead;
    private PoolItem _xaNext;
    private boolean _hasConnectionError;
    private long _poolStartTime;
    private long _poolEventTime;
    private Xid _xid;
    private int _endFlags;
    private boolean _isXATransaction;
    private boolean _isLocalTransaction;
    private IllegalStateException _allocationStackTrace;

    public PoolItem(ConnectionPool cm, ManagedConnectionFactory mcf, ManagedConnection conn) {
        block10: {
            this._endFlags = -1;
            this._isXATransaction = true;
            this._cm = cm;
            this._id = this._cm.generateId();
            this._mcf = mcf;
            this._mConn = conn;
            this._poolStartTime = Alarm.getCurrentTime();
            this._poolEventTime = Alarm.getCurrentTime();
            try {
                if (!cm.isXATransaction()) break block10;
                XAResource xaResource = conn.getXAResource();
                try {
                    this._defaultTransactionTimeout = xaResource.getTransactionTimeout();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                this._xaResource = xaResource;
            }
            catch (NotSupportedException e) {
                this._cm.setXATransaction(false);
                log.log(Level.FINER, e.toString(), e);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        try {
            if (this._cm.isLocalTransaction()) {
                this._localTransaction = conn.getLocalTransaction();
            }
        }
        catch (NotSupportedException e) {
            this._cm.setLocalTransaction(false);
            log.log(Level.FINE, e.toString(), e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this._mConn.addConnectionEventListener(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("create: " + this + "(active:" + this._cm.getActiveConnectionCount() + ", total:" + this._cm.getConnectionCount() + ")");
        }
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public void setInfo(ConnectionRequestInfo info) {
        this._requestInfo = info;
    }

    public boolean isActive() {
        return this._shareHead != null;
    }

    public boolean isDead() {
        return this._mConn == null;
    }

    public long getEventTime() {
        return this._poolEventTime;
    }

    public long getStartTime() {
        return this._poolStartTime;
    }

    void setTransaction(UserTransactionImpl transaction) {
        this._transaction = transaction;
    }

    synchronized UserPoolItem toActive(Subject subject, ConnectionRequestInfo info, UserPoolItem userPoolItem) throws ResourceException {
        long now = Alarm.getCurrentTime();
        long maxIdleTime = this._cm.getMaxIdleTime();
        long maxPoolTime = this._cm.getMaxPoolTime();
        if (this._hasConnectionError) {
            return null;
        }
        if (0L < maxIdleTime && this._poolEventTime + maxIdleTime < now) {
            return null;
        }
        if (0L < maxPoolTime && this._poolStartTime + maxPoolTime < now) {
            return null;
        }
        this._poolEventTime = now;
        this._isXATransaction = true;
        if (userPoolItem != null) {
            Object uConn = userPoolItem.getUserConnection();
            if (uConn != null) {
                this._mConn.associateConnection(uConn);
            }
            userPoolItem.associatePoolItem(this);
        } else {
            userPoolItem = this._userPoolItem != null ? this._userPoolItem : new UserPoolItem(this._cm, this);
        }
        if (!this.isValid(subject, info, userPoolItem)) {
            return null;
        }
        this._userPoolItem = userPoolItem;
        this._subject = subject;
        this._requestInfo = info;
        this._shareHead = this._userPoolItem.associate(this, this._shareHead, this._mcf, subject, info);
        if (log.isLoggable(Level.FINE)) {
            log.fine("allocate " + this);
        }
        if (this._cm.getSaveAllocationStackTrace()) {
            this._allocationStackTrace = new IllegalStateException(L.l("Connection {0} allocation stack trace", this));
        }
        return this._userPoolItem;
    }

    synchronized boolean isValid() {
        long now = Alarm.getCurrentTime();
        long maxIdleTime = this._cm.getMaxIdleTime();
        long maxPoolTime = this._cm.getMaxPoolTime();
        long maxActiveTime = this._cm.getMaxActiveTime();
        boolean isActive = this.isActive();
        boolean isDead = false;
        if (!isActive && this._hasConnectionError) {
            isDead = true;
            log.fine("closing pool item from connection error:" + this);
        } else if (!isActive && 0L < maxIdleTime && this._poolEventTime + maxIdleTime < now) {
            isDead = true;
            log.fine("closing pool item from idle timeout:" + this);
        } else if (!isActive && 0L < maxPoolTime && this._poolStartTime + maxPoolTime < now) {
            isDead = true;
            log.fine("closing pool item from pool timeout:" + this);
        } else if (isActive && 0L < maxActiveTime && this._poolEventTime + maxActiveTime < now) {
            isDead = true;
            log.warning("closing pool item from active timeout:" + this);
        }
        if (isDead) {
            this._hasConnectionError = true;
            return false;
        }
        return true;
    }

    UserPoolItem allocateXA(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (this._mConn == null) {
            return null;
        }
        if (this._subject != subject) {
            return null;
        }
        if (this._requestInfo != info) {
            return null;
        }
        if (this._mcf != mcf) {
            return null;
        }
        if (this._shareHead != null && !this._cm.isShareable()) {
            return null;
        }
        if (this._hasConnectionError) {
            return null;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("sharing xa-pool item: " + this);
        }
        UserPoolItem userPoolItem = new UserPoolItem(this._cm);
        this._shareHead = userPoolItem.associate(this, this._shareHead, this._mcf, this._subject, this._requestInfo);
        return userPoolItem;
    }

    boolean isJoin(PoolItem item) {
        if (this == item) {
            return false;
        }
        if (this._xid != item._xid) {
            return false;
        }
        return this._mcf == item._mcf;
    }

    boolean share(UserPoolItem userPoolItem) {
        if (this._mConn == null) {
            return false;
        }
        if (!this._cm.isShareable()) {
            return false;
        }
        if (this._mcf != userPoolItem.getManagedConnectionFactory()) {
            return false;
        }
        if (this._subject != userPoolItem.getSubject()) {
            return false;
        }
        if (this._requestInfo != userPoolItem.getInfo()) {
            return false;
        }
        if (this._hasConnectionError) {
            return false;
        }
        return false;
    }

    ManagedConnection getManagedConnection() {
        return this._mConn;
    }

    Object getUserConnection() throws ResourceException {
        return this._userPoolItem.getUserConnection();
    }

    Object allocateConnection() throws ResourceException {
        return this._mConn.getConnection(this._subject, this._requestInfo);
    }

    boolean isValid(Subject subject, ConnectionRequestInfo requestInfo, UserPoolItem userPoolItem) {
        try {
            ManagedConnection mConn = this.getManagedConnection();
            if (mConn == null) {
                return false;
            }
            Object userConn = userPoolItem.getUserConnection();
            if (userConn == null) {
                userConn = mConn.getConnection(subject, requestInfo);
                userPoolItem.setUserConnection(userConn);
            }
            return userConn != null;
        }
        catch (ResourceException e) {
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
    }

    void enableLocalTransactionOptimization(boolean enableOptimization) {
        this._isXATransaction = this._xaResource == null ? false : (this._localTransaction == null ? true : (!this._cm.isLocalTransactionOptimization() ? true : (!this._cm.isShareable() ? true : !enableOptimization)));
    }

    boolean supportsTransaction() {
        return true;
    }

    XAResource getXAResource() {
        return this._xaResource;
    }

    Xid getXid() {
        return this._xid;
    }

    public void connectionClosed(ConnectionEvent event) {
        boolean addIdle = false;
        Object handle = event.getConnectionHandle();
        if (!this._hasConnectionError && handle == null && this._shareHead != null) {
            log.fine(L.l("JCA close event '{0}' for {1} did not have a connection handle.  Please notify the JCA resource provider.", (Object)event, this._mConn));
        }
        if (this._shareHead == null) {
            this.toIdle();
            return;
        }
        UserPoolItem userPoolItem = this._shareHead;
        while (userPoolItem != null) {
            UserPoolItem next = userPoolItem.getShareNext();
            Object userConn = userPoolItem.getUserConnection();
            if (userConn == handle || handle == null) {
                userPoolItem.toClose();
            }
            userPoolItem = next;
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
        if (this._isLocalTransaction || this._xid != null) {
            throw new IllegalStateException(L.l("attempted to start local transaction while transaction is in progress."));
        }
        if (this._localTransaction != null) {
            try {
                this._localTransaction.begin();
                this._isLocalTransaction = true;
            }
            catch (ResourceException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        if (this._xid != null) {
            throw new IllegalStateException(L.l("attempted to commit() local transaction from an active XA transaction."));
        }
        if (!this._isLocalTransaction) {
            throw new IllegalStateException(L.l("attempted to commit() with no active local transaction."));
        }
        if (this._localTransaction != null && this._isLocalTransaction) {
            try {
                this._isLocalTransaction = false;
                this._localTransaction.commit();
            }
            catch (ResourceException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        if (this._xid != null) {
            throw new IllegalStateException(L.l("attempted to rollback() local transaction from an active XA transaction."));
        }
        if (!this._isLocalTransaction) {
            throw new IllegalStateException(L.l("attempted to rollback() with no active local transaction."));
        }
        if (this._localTransaction != null) {
            try {
                this._isLocalTransaction = false;
                this._localTransaction.rollback();
            }
            catch (ResourceException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this._hasConnectionError = true;
    }

    public boolean isConnectionError() {
        return this._hasConnectionError;
    }

    public IllegalStateException getAllocationStackTrace() {
        return this._allocationStackTrace;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (!(resource instanceof PoolItem)) {
            return false;
        }
        PoolItem poolItem = (PoolItem)resource;
        if (this._xaResource == null) {
            return false;
        }
        boolean isSameRM = this._xaResource.isSameRM(poolItem._xaResource);
        if (log.isLoggable(Level.FINER)) {
            log.finer("isSameRM->" + isSameRM + " " + this._xaResource);
        }
        return isSameRM;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this._xid != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("connection pool start XA: rejoin " + this);
            }
            return;
        }
        if (flags == 0x200000 && this._xid == null) {
            PoolItem xaHead;
            this._xid = xid;
            UserTransactionImpl trans = this._cm.getTransaction();
            if (trans != null && (xaHead = trans.findJoin(this)) != null) {
                this._xaNext = xaHead._xaNext;
                this._xaHead = xaHead;
                xaHead._xaNext = this;
            }
        }
        if (!this._isXATransaction && flags != 0x200000 && this._localTransaction != null) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("begin-local-XA: " + this._localTransaction);
                }
                this._localTransaction.begin();
            }
            catch (ResourceException e) {
                throw new XAExceptionWrapper(e);
            }
            this._xid = xid;
            return;
        }
        if (this._xaResource != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("start-XA: " + xid + " " + this._xaResource);
            }
            this._xaResource.start(xid, flags);
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("start-XA with non XA resource: " + xid + " " + this._xaResource);
        }
        this._xid = xid;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds == this._transactionTimeout) {
            return true;
        }
        XAResource xaResource = this._xaResource;
        this._transactionTimeout = seconds;
        if (xaResource == null) {
            return true;
        }
        if (seconds == 0) {
            return xaResource.setTransactionTimeout(this._defaultTransactionTimeout);
        }
        return xaResource.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this._transactionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            if (this._isXATransaction) {
                this._xaResource.forget(xid);
            }
        }
        finally {
            this.clearXid();
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this._endFlags != -1) {
            int endFlags = this._endFlags;
            this._endFlags = -1;
            if (this._isXATransaction) {
                this.endResource(xid, endFlags);
            }
        }
        if (this._isXATransaction) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("prepare-XA: " + xid + " " + this._xaResource);
                }
                return this._xaResource.prepare(xid);
            }
            catch (XAException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("failed prepare-XA: " + xid + " " + this._xaResource + " " + e);
                }
                throw e;
            }
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this._isXATransaction) {
            return this._xaResource.recover(flag);
        }
        return null;
    }

    public void end(Xid xid, int flags) throws XAException {
        this._endFlags = flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        block15: {
            try {
                if (this._endFlags != -1) {
                    try {
                        int endFlags = this._endFlags;
                        this._endFlags = -1;
                        if (this._isXATransaction) {
                            this.endResource(xid, endFlags);
                        }
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        if (this._isXATransaction) {
                            this._xaResource.rollback(xid);
                        }
                        if (this._xaResource != null) {
                            this._isXATransaction = true;
                        }
                        this.clearXid();
                        return;
                    }
                }
                if (log.isLoggable(Level.FINER)) {
                    log.finer("connection pool rollback XA: " + this);
                }
                if (this._isXATransaction) {
                    this._xaResource.rollback(xid);
                    break block15;
                }
                if (this._localTransaction == null) break block15;
                try {
                    this._isLocalTransaction = false;
                    this._localTransaction.rollback();
                }
                catch (ResourceException e) {
                    throw new XAExceptionWrapper(e);
                }
            }
            finally {
                if (this._xaResource != null) {
                    this._isXATransaction = true;
                }
                this.clearXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block20: {
            boolean logFiner = log.isLoggable(Level.FINER);
            try {
                if (this._endFlags != -1) {
                    try {
                        int endFlags = this._endFlags;
                        this._endFlags = -1;
                        if (this._isXATransaction) {
                            this.endResource(xid, endFlags);
                        }
                    }
                    catch (XAException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        this._xaResource.rollback(xid);
                        throw e;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        this._xaResource.rollback(xid);
                        throw new XAException(104);
                    }
                }
                if (this._isXATransaction) {
                    if (logFiner) {
                        log.finer("commit-XA" + (onePhase ? "-1p: " : ": ") + xid + " " + this._xaResource);
                    }
                    try {
                        this._xaResource.commit(xid, onePhase);
                        break block20;
                    }
                    catch (XAException e) {
                        if (logFiner) {
                            log.finer("commit-XA failed: " + this._xaResource + " " + e);
                        }
                        throw e;
                    }
                }
                if (this._localTransaction != null) {
                    if (logFiner) {
                        log.finer("commit-local: " + this._localTransaction);
                    }
                    try {
                        this._isLocalTransaction = false;
                        this._localTransaction.commit();
                        break block20;
                    }
                    catch (ResourceException e) {
                        if (logFiner) {
                            log.finer("commit failed: " + this._localTransaction + " " + e);
                        }
                        throw new XAExceptionWrapper(e);
                    }
                }
                if (logFiner) {
                    log.finer("commit for resource with no XA support: " + this);
                }
            }
            finally {
                if (this._xaResource != null) {
                    this._isXATransaction = true;
                }
                this.clearXid();
            }
        }
    }

    private void endResource(Xid xid, int flags) throws XAException {
        PoolItem xaPtr = this;
        while (xaPtr != null) {
            if (xaPtr._xaResource != null) {
                xaPtr._xaResource.end(xid, flags);
            }
            xaPtr = xaPtr._xaNext;
        }
    }

    private void clearXid() {
        Object next;
        this._xid = null;
        UserPoolItem shareHead = this._shareHead;
        Object xaPtr = this._xaNext;
        this._xaHead = null;
        this._xaNext = null;
        boolean isClosed = true;
        Object ptr = shareHead;
        while (ptr != null) {
            next = ((UserPoolItem)ptr).getShareNext();
            if (((UserPoolItem)ptr).getPoolItem() == this) {
                isClosed = false;
            }
            try {
                ((UserPoolItem)ptr).reassociatePoolItem();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            ptr = next;
        }
        while (xaPtr != null) {
            next = ((PoolItem)xaPtr)._xaNext;
            ((PoolItem)xaPtr)._xaNext = null;
            ((PoolItem)xaPtr)._xaHead = null;
            ((PoolItem)xaPtr).clearXid();
            xaPtr = next;
        }
        if (isClosed) {
            if (this._hasConnectionError) {
                this._shareHead = null;
                this.toDead();
            } else {
                this._shareHead = null;
                this.toIdle();
            }
        }
    }

    void toIdle() {
        if (this._shareHead != null) {
            return;
        }
        if (this._xid != null || this._isLocalTransaction) {
            return;
        }
        if (this._hasConnectionError) {
            this.toDead();
            return;
        }
        UserTransactionImpl transaction = this._transaction;
        this._transaction = null;
        if (transaction != null) {
            try {
                transaction.delistPoolItem(this, 0x4000000);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this._isLocalTransaction = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("idle " + this);
        }
        this._poolEventTime = Alarm.getCurrentTime();
        this._cm.toIdle(this);
    }

    void abortConnection() throws ResourceException {
        this.toDead();
    }

    private void toDead() {
        this._cm.toDead(this);
    }

    void destroy() throws ResourceException {
        ManagedConnection mConn = this._mConn;
        this._mConn = null;
        UserTransactionImpl transaction = this._transaction;
        this._transaction = null;
        if (mConn == null) {
            return;
        }
        UserPoolItem userItem = this._shareHead;
        this._shareHead = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("connection pool destroy " + this);
        }
        try {
            if (transaction != null) {
                while (userItem != null) {
                    transaction.delistResource(userItem);
                    userItem = userItem.getShareNext();
                }
                transaction.delistPoolItem(this, 0x20000000);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        mConn.destroy();
    }

    public String toString() {
        return "PoolItem[" + this._cm.getName() + "," + this._id + "," + this._mConn + "]";
    }
}

