/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.MysqlMetaData;
import com.caucho.jdbc.OracleMetaData;
import com.caucho.jdbc.PostgresMetaData;
import com.caucho.jdbc.ResinMetaData;
import com.caucho.jdbc.SqlServerMetaData;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcMetaData {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jdbc/JdbcMetaData"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jdbc/JdbcMetaData"));

    protected JdbcMetaData() {
    }

    public static JdbcMetaData create() {
        return new JdbcMetaData();
    }

    public static JdbcMetaData create(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            String name = md.getDatabaseProductName();
            log.fine(L.l("Database '{0}' metadata.", name));
            if ("oracle".equalsIgnoreCase(name)) {
                return new OracleMetaData();
            }
            if ("resin".equalsIgnoreCase(name)) {
                return new ResinMetaData();
            }
            if ("postgres".equalsIgnoreCase(name) || "PostgreSQL".equalsIgnoreCase(name)) {
                return new PostgresMetaData();
            }
            if ("mysql".equalsIgnoreCase(name)) {
                return new MysqlMetaData();
            }
            if ("Microsoft SQL Server".equalsIgnoreCase(name)) {
                return new SqlServerMetaData();
            }
            log.fine(name + " is an unknown database type");
            return new JdbcMetaData();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return new JdbcMetaData();
        }
    }

    public String getDatabaseName(Connection conn) throws SQLException {
        DatabaseMetaData md = conn.getMetaData();
        return md.getDatabaseProductName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBlobType(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != 2004) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    short dataType = rs.getShort("DATA_TYPE");
                    if (rs.getShort("DATA_TYPE") != -4) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -2) continue;
                    String string = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                do {
                    if (!rs.next()) return null;
                } while (rs.getShort("DATA_TYPE") != -3);
                String string = rs.getString("TYPE_NAME");
                return string;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    public boolean supportsIdentity() {
        return false;
    }

    public String createIdentitySQL(String sqlType) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean supportsSequences() {
        return false;
    }

    public String createSequenceSQL(String name, int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String selectSequenceSQL(String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String testSequenceSQL(String name) {
        return this.selectSequenceSQL(name) + " WHERE 1=0";
    }

    public String limit(String sql, int max) {
        return sql;
    }

    public String getCreateTableSQL(int sqlType, int length) {
        switch (sqlType) {
            case -7: {
                return "TINYINT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 1: {
                return "CHAR";
            }
        }
        return "VARCHAR(" + length + ")";
    }
}

