/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms;

import com.caucho.config.ConfigException;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcQueue;
import com.caucho.jms.jdbc.JdbcTopic;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemoryTopic;
import com.caucho.jms.session.ConnectionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.sql.DataSource;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/ConnectionFactoryImpl"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/ConnectionFactoryImpl"));
    private String _clientID;
    private String _user;
    private String _password;
    private JdbcManager _jdbcManager;
    private ArrayList<ConnectionImpl> _connections = new ArrayList();
    private HashMap<String, Queue> _queues = new HashMap();
    private HashMap<String, Topic> _topics = new HashMap();

    public void setUser(String user) {
        this._user = user;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setClientID(String id) {
        this._clientID = id;
    }

    public void setDataSource(DataSource dataSource) {
        if (this._jdbcManager == null) {
            this._jdbcManager = new JdbcManager();
        }
        this._jdbcManager.setDataSource(dataSource);
    }

    public JdbcManager getJdbcManager() {
        return new JdbcManager();
    }

    public void init() throws ConfigException, SQLException {
        if (this._jdbcManager != null) {
            this._jdbcManager.init();
        }
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this._user, this._password);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        ConnectionImpl conn = new ConnectionImpl(this);
        if (this._clientID != null) {
            if (this.findByClientID(this._clientID) != null) {
                throw new JMSException(L.l("ClientID[{0}] is only allowed for a single connection.", this._clientID));
            }
            conn.setClientID(this._clientID);
        }
        this.addConnection(conn);
        return conn;
    }

    protected void addConnection(ConnectionImpl conn) {
        this._connections.add(conn);
    }

    public ConnectionImpl findByClientID(String id) {
        for (int i = 0; i < this._connections.size(); ++i) {
            ConnectionImpl conn = this._connections.get(i);
            try {
                if (!id.equals(conn.getClientID())) continue;
                return conn;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return null;
    }

    public void removeConnection(ConnectionImpl conn) {
        this._connections.remove(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String name) throws JMSException {
        try {
            HashMap<String, Queue> hashMap = this._queues;
            synchronized (hashMap) {
                Queue queue = this._queues.get(name);
                if (queue != null) {
                    return queue;
                }
                if (this._jdbcManager != null) {
                    JdbcQueue jdbcQueue = new JdbcQueue();
                    jdbcQueue.setJdbcManager(this._jdbcManager);
                    jdbcQueue.setQueueName(name);
                    jdbcQueue.init();
                    this._queues.put(name, jdbcQueue);
                    return jdbcQueue;
                }
                MemoryQueue memoryQueue = new MemoryQueue();
                memoryQueue.setQueueName(name);
                this._queues.put(name, memoryQueue);
                return memoryQueue;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String name) throws JMSException {
        try {
            HashMap<String, Topic> hashMap = this._topics;
            synchronized (hashMap) {
                Topic topic = this._topics.get(name);
                if (topic != null) {
                    return topic;
                }
                if (this._jdbcManager != null) {
                    JdbcTopic jdbcTopic = new JdbcTopic();
                    jdbcTopic.setJdbcManager(this._jdbcManager);
                    jdbcTopic.setTopicName(name);
                    jdbcTopic.init();
                    this._topics.put(name, jdbcTopic);
                    return jdbcTopic;
                }
                MemoryTopic memoryTopic = new MemoryTopic();
                memoryTopic.setTopicName(name);
                this._topics.put(name, memoryTopic);
                return memoryTopic;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    protected void authenticate(String username, String password) throws JMSException {
        if (this._user != null && !this._user.equals(username) || this._password != null && !this._password.equals(password)) {
            throw new JMSSecurityException(L.l("'{0}' is an unknown user", username));
        }
    }
}

