/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.jms.jca.ResourceAdapterImpl;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;

public class MessageListenerTask
implements Work {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jca/MessageListenerTask"));
    private MessageEndpoint _endpoint;
    private MessageListener _listener;
    private ResourceAdapterImpl _ra;
    private QueueConnection _queueConnection;
    private QueueSession _queueSession;
    private QueueReceiver _queueConsumer;
    private TopicConnection _topicConnection;
    private TopicSession _topicSession;
    private TopicSubscriber _topicConsumer;
    private Connection _connection;
    private Session _session;
    private MessageConsumer _consumer;
    private volatile boolean _isClosed;

    MessageListenerTask(ResourceAdapterImpl ra, MessageEndpoint endpoint) throws JMSException {
        this._endpoint = endpoint;
        this._listener = (MessageListener)endpoint;
        this._ra = ra;
        this.init();
    }

    void init() throws JMSException {
        ConnectionFactory factory = this._ra.getConnectionFactory();
        Destination queue = this._ra.getDestination();
        if (queue instanceof Queue && factory instanceof QueueConnectionFactory) {
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)factory;
            this._queueConnection = queueFactory.createQueueConnection();
            this._queueSession = this._queueConnection.createQueueSession(false, 1);
            this._queueConsumer = this._queueSession.createReceiver((Queue)queue);
            this._queueConnection.start();
        } else if (queue instanceof Topic && factory instanceof TopicConnectionFactory) {
            TopicConnectionFactory topicFactory = (TopicConnectionFactory)factory;
            this._topicConnection = topicFactory.createTopicConnection();
            this._topicSession = this._topicConnection.createTopicSession(false, 1);
            this._topicConsumer = this._topicSession.createSubscriber((Topic)queue);
            this._topicConnection.start();
        } else {
            this._connection = factory.createConnection();
            this._session = this._connection.createSession(false, 1);
            this._consumer = this._session.createConsumer(queue);
            this._connection.start();
        }
    }

    public void run() {
        while (!this._isClosed) {
            try {
                Message msg;
                if (this._consumer != null) {
                    msg = this._consumer.receive(60000L);
                } else if (this._queueConsumer != null) {
                    msg = this._queueConsumer.receive(60000L);
                } else if (this._topicConsumer != null) {
                    msg = this._topicConsumer.receive(60000L);
                } else {
                    this._isClosed = true;
                    throw new IllegalStateException();
                }
                if (msg == null) continue;
                this._listener.onMessage(msg);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void release() {
        this._isClosed = true;
        Connection connection = this._connection;
        try {
            if (connection != null) {
                connection.stop();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._connection = null;
        Session session = this._session;
        this._session = null;
        MessageConsumer consumer = this._consumer;
        this._consumer = null;
        MessageEndpoint endpoint = this._endpoint;
        this._endpoint = null;
        try {
            if (consumer != null) {
                consumer.close();
            }
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this._listener = null;
        if (endpoint != null) {
            endpoint.release();
        }
    }
}

