/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.jms.jca.ManagedSessionImpl;
import com.caucho.jms.jca.MessageSenderManager;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.resource.spi.ConnectionManager;

class MessageSenderImpl
implements MessageSender {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jca/MessageSenderImpl"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jca/MessageSenderImpl"));
    private MessageSenderManager _manager;
    private ConnectionManager _cm;

    MessageSenderImpl(MessageSenderManager manager, ConnectionManager cm) {
        this._manager = manager;
        this._cm = cm;
    }

    public void send(HashMap header, Object value) throws MessageServiceException {
        ManagedSessionImpl session = null;
        try {
            Message message;
            session = (ManagedSessionImpl)this._cm.allocateConnection(this._manager, null);
            if (value == null) {
                message = session.getSession().createMessage();
            } else if (value instanceof String) {
                message = session.getSession().createTextMessage((String)value);
            } else if (value instanceof Serializable) {
                ObjectMessage objMessage = session.getSession().createObjectMessage();
                objMessage.setObject((Serializable)value);
                message = objMessage;
            } else {
                throw new MessageServiceException(L.l("value '{0}' must be serializable", value));
            }
            session.send(message);
        }
        catch (MessageServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageServiceException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

