/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcQueue;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SelectorParser;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class JdbcQueueBrowser
implements QueueBrowser {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcQueueBrowser"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcQueueBrowser"));
    private SessionImpl _session;
    private JdbcManager _jdbcManager;
    private JdbcQueue _queue;
    private String _messageSelector;
    private Selector _selector;
    private boolean _isClosed;

    public JdbcQueueBrowser(SessionImpl session, String messageSelector, JdbcQueue queue) throws JMSException {
        this._session = session;
        this._jdbcManager = queue.getJdbcManager();
        this._queue = queue;
        this._messageSelector = messageSelector;
        if (this._messageSelector != null) {
            SelectorParser parser = new SelectorParser();
            this._selector = parser.parse(messageSelector);
        }
    }

    public Queue getQueue() {
        return this._queue;
    }

    public String getMessageSelector() {
        return this._messageSelector;
    }

    public Enumeration getEnumeration() {
        return new BrowserEnumeration();
    }

    public void close() throws JMSException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
    }

    public String toString() {
        return "JdbcQueueBrowser[" + this._queue + "]";
    }

    class BrowserEnumeration
    implements Enumeration {
        private long _maxId = -1L;
        private Message _msg;

        BrowserEnumeration() {
        }

        public boolean hasMoreElements() {
            if (this._msg == null) {
                this.getNextMessage();
            }
            return this._msg != null;
        }

        public Object nextElement() {
            if (this._msg == null) {
                this.getNextMessage();
            }
            Message msg = this._msg;
            this._msg = null;
            return msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message getNextMessage() {
            try {
                Connection conn = JdbcQueueBrowser.this._jdbcManager.getDataSource().getConnection();
                String messageTable = JdbcQueueBrowser.this._jdbcManager.getMessageTable();
                try {
                    String sql = "SELECT m_id, msg_type, delivered, body, header FROM " + messageTable + " WHERE ?<m_id AND queue=?" + "  AND consumer IS NULL AND ?<expire";
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, this._maxId);
                    pstmt.setInt(2, JdbcQueueBrowser.this._queue.getId());
                    pstmt.setLong(3, Alarm.getCurrentTime());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this._maxId = rs.getLong(1);
                        this._msg = JdbcQueueBrowser.this._jdbcManager.getJdbcMessage().readMessage(rs);
                        if (JdbcQueueBrowser.this._selector == null || JdbcQueueBrowser.this._selector.isMatch(this._msg)) break;
                        this._msg = null;
                    }
                    rs.close();
                    pstmt.close();
                }
                finally {
                    conn.close();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            return this._msg;
        }
    }
}

