/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcDestination;
import com.caucho.jms.jdbc.JdbcTopicConsumer;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class JdbcTopic
extends JdbcDestination
implements Topic {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcTopic"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcTopic"));
    private int _id;

    public String getTopicName() {
        return this.getName();
    }

    public void setTopicName(String name) {
        this.setName(name);
    }

    public boolean isTopic() {
        return true;
    }

    public int getId() {
        return this._id;
    }

    public void init() throws ConfigException, SQLException {
        if (this._jdbcManager.getDataSource() == null) {
            throw new ConfigException(L.l("JdbcTopic requires a <data-source> element."));
        }
        if (this.getName() == null) {
            throw new ConfigException(L.l("JdbcTopic requires a <topic-name> element."));
        }
        this._jdbcManager.init();
        this._id = this.createDestination(this.getName(), true);
    }

    public MessageConsumerImpl createConsumer(SessionImpl session, String selector, boolean noLocal) throws JMSException {
        return new JdbcTopicConsumer(session, selector, this._jdbcManager, this, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(SessionImpl session, String selector, boolean noLocal, String name) throws JMSException {
        return new JdbcTopicConsumer(session, selector, this._jdbcManager, this, noLocal, name);
    }

    public void send(Message message) throws JMSException {
        long expireTime = message.getJMSExpiration();
        if (expireTime <= 0L) {
            expireTime = 0x3FFFFFFFFFFFFFFFL;
        }
        this.purgeExpiredMessages();
        try {
            this._jdbcManager.getJdbcMessage().send(message, this._id, expireTime);
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        this.messageAvailable();
    }

    public String toString() {
        return "JdbcTopic[" + this.getName() + "]";
    }
}

