/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.memory.MemoryQueueBrowser;
import com.caucho.jms.memory.MemoryQueueConsumer;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;

public class MemoryQueue
extends AbstractDestination
implements Queue {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryQueue"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryQueue"));
    ArrayList<Item> _queue = new ArrayList();
    private String _queueName;
    private Selector _selector;
    private int _consumerId;

    public String getQueueName() {
        return this._queueName;
    }

    public void setQueueName(String name) {
        this._queueName = name;
    }

    public void setSelector(Selector selector) {
        this._selector = selector;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public int generateConsumerId() {
        return ++this._consumerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        if (this._selector != null && !this._selector.isMatch(message)) {
            return;
        }
        long sequenceId = this.nextConsumerSequenceId();
        if (log.isLoggable(Level.FINE)) {
            log.fine("MemoryQueue[" + this._queueName + "] send " + sequenceId);
        }
        ArrayList<Item> arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.add(new Item((MessageImpl)message));
            this._queue.notify();
        }
        this.messageAvailable();
    }

    public MessageConsumer createConsumer(SessionImpl session, String selector, boolean noLocal) throws JMSException {
        return new MemoryQueueConsumer(session, selector, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageImpl receive(Selector selector, long consumerId, boolean autoAck) throws JMSException {
        ArrayList<Item> arrayList = this._queue;
        synchronized (arrayList) {
            int size = this._queue.size();
            for (int i = 0; i < size; ++i) {
                Item item = this._queue.get(i);
                if (item.getConsumerId() >= 0L) continue;
                MessageImpl message = item.getMessage();
                if (selector != null && !selector.isMatch(message)) continue;
                message.setJMSRedelivered(item.getDelivered());
                if (autoAck) {
                    this._queue.remove(i);
                } else {
                    item.setConsumerId(consumerId);
                }
                return message;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(long consumerId) throws JMSException {
        ArrayList<Item> arrayList = this._queue;
        synchronized (arrayList) {
            for (int i = this._queue.size() - 1; i >= 0; --i) {
                Item item = this._queue.get(i);
                if (item.getConsumerId() != consumerId) continue;
                item.setConsumerId(-1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(long consumerId, long messageId) throws JMSException {
        ArrayList<Item> arrayList = this._queue;
        synchronized (arrayList) {
            for (int i = this._queue.size() - 1; i >= 0; --i) {
                Item item = this._queue.get(i);
                if (item.getConsumerId() != consumerId) continue;
                this._queue.remove(i);
            }
        }
    }

    public MemoryQueueBrowser createBrowser(SessionImpl session, String selector) throws JMSException {
        return new MemoryQueueBrowser(session, this, selector);
    }

    public Enumeration getEnumeration(Selector selector) {
        return new BrowserEnumeration(this, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessage(Selector selector) throws JMSException {
        ArrayList<Item> arrayList = this._queue;
        synchronized (arrayList) {
            int size = this._queue.size();
            for (int i = 0; i < size; ++i) {
                Item item = this._queue.get(i);
                if (item.getConsumerId() >= 0L) continue;
                MessageImpl message = item.getMessage();
                if (selector != null && !selector.isMatch(message)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "MemoryQueue[" + this._queueName + "]";
    }

    static class Item {
        private MessageImpl _msg;
        private long _consumerId = -1L;
        private boolean _delivered;

        Item(MessageImpl msg) {
            this._msg = msg;
        }

        MessageImpl getMessage() {
            return this._msg;
        }

        long getConsumerId() {
            return this._consumerId;
        }

        void setConsumerId(long consumerId) {
            this._consumerId = consumerId;
            this._delivered = true;
        }

        boolean getDelivered() {
            return this._delivered;
        }
    }

    static class BrowserEnumeration
    implements Enumeration {
        private MemoryQueue _queue;
        private Selector _selector;

        BrowserEnumeration(MemoryQueue queue, Selector selector) {
            this._queue = queue;
            this._selector = selector;
        }

        public boolean hasMoreElements() {
            try {
                return this._queue.hasMessage(this._selector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object nextElement() {
            try {
                return this._queue.receive(this._selector, -1L, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

