/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.jms.message.ObjectConverter;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/message/MessageImpl"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/message/MessageImpl"));
    private static final HashSet<String> _reserved = new HashSet();
    private volatile SoftReference<SessionImpl> _sessionRef;
    private String _messageId;
    private String _correlationId;
    private long _timestamp;
    private long _expiration;
    private Destination _destination;
    private Destination _replyTo;
    private int _deliveryMode;
    private boolean _isRedelivered;
    private String _messageType;
    private int _priority = 4;
    private HashMap<String, Object> _properties;
    private boolean _isHeaderWriteable = true;
    private boolean _isBodyWriteable = true;

    public void setSession(SessionImpl session) {
        this._sessionRef = new SoftReference<SessionImpl>(session);
    }

    public String getJMSMessageID() throws JMSException {
        return this._messageId;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this._messageId = id;
    }

    public long getJMSTimestamp() throws JMSException {
        return this._timestamp;
    }

    public void setJMSTimestamp(long time) throws JMSException {
        this._timestamp = time;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        try {
            if (this._correlationId == null) {
                return null;
            }
            return this._correlationId.getBytes("UTF8");
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] id) throws JMSException {
        try {
            this._correlationId = new String(id, 0, id.length, "UTF8");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._correlationId;
    }

    public void setJMSCorrelationID(String id) throws JMSException {
        this._correlationId = id;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this._replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this._replyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this._destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this._deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this._deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._isRedelivered;
    }

    public void setJMSRedelivered(boolean isRedelivered) throws JMSException {
        this._isRedelivered = isRedelivered;
    }

    public String getJMSType() throws JMSException {
        return this._messageType;
    }

    public void setJMSType(String type) throws JMSException {
        this._messageType = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this._expiration;
    }

    public void setJMSExpiration(long time) throws JMSException {
        this._expiration = time;
    }

    public int getJMSPriority() throws JMSException {
        return this._priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this._priority = priority;
    }

    public void clearProperties() throws JMSException {
        if (this._properties != null) {
            this._properties.clear();
        }
        this._isHeaderWriteable = true;
    }

    public boolean propertyExists(String name) throws JMSException {
        if (this._properties == null) {
            return false;
        }
        return this._properties.keySet().contains(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return ObjectConverter.toBoolean(this.getObjectProperty(name));
    }

    public byte getByteProperty(String name) throws JMSException {
        return ObjectConverter.toByte(this.getObjectProperty(name));
    }

    public short getShortProperty(String name) throws JMSException {
        return ObjectConverter.toShort(this.getObjectProperty(name));
    }

    public int getIntProperty(String name) throws JMSException {
        return ObjectConverter.toInt(this.getObjectProperty(name));
    }

    public long getLongProperty(String name) throws JMSException {
        return ObjectConverter.toLong(this.getObjectProperty(name));
    }

    public float getFloatProperty(String name) throws JMSException {
        return ObjectConverter.toFloat(this.getObjectProperty(name));
    }

    public double getDoubleProperty(String name) throws JMSException {
        return ObjectConverter.toDouble(this.getObjectProperty(name));
    }

    public String getStringProperty(String name) throws JMSException {
        Object prop = this.getObjectProperty(name);
        if (prop == null) {
            return null;
        }
        return String.valueOf(prop);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (this._properties == null || name == null) {
            return null;
        }
        return this._properties.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (this._properties == null) {
            return NullEnumeration.create();
        }
        return Collections.enumeration(this._properties.keySet());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, new Byte(value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, new Short(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, new Long(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertyWriteable();
        if (name == null) {
            throw new NullPointerException();
        }
        if (MessageImpl.isReserved(name)) {
            throw new JMSException(L.l("'{0}' is a reserved property name.", name));
        }
        if (!(value == null || value instanceof Number || value instanceof String || value instanceof Boolean)) {
            throw new MessageFormatException(L.l("{0} is an illegal object property value", value.getClass().getName()));
        }
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(name, value);
    }

    public void acknowledge() throws JMSException {
        SessionImpl session;
        SoftReference<SessionImpl> sessionRef = this._sessionRef;
        if (sessionRef != null && (session = sessionRef.get()) != null) {
            session.acknowledge();
        }
        this._sessionRef = null;
    }

    public void clearBody() throws JMSException {
        this._isBodyWriteable = true;
    }

    public void setReceive() throws JMSException {
        this._isHeaderWriteable = false;
        this._isBodyWriteable = false;
    }

    protected void setBodyReadOnly() throws JMSException {
        this._isBodyWriteable = false;
    }

    public HashMap<String, Object> getProperties() {
        return this._properties;
    }

    public MessageImpl copy() {
        MessageImpl msg = new MessageImpl();
        this.copy(msg);
        return msg;
    }

    protected void checkHeaderWriteable() throws JMSException {
        if (!this._isHeaderWriteable) {
            throw new MessageNotWriteableException(L.l("received messages can't be written."));
        }
    }

    protected void checkPropertyWriteable() throws JMSException {
        if (!this._isHeaderWriteable) {
            throw new MessageNotWriteableException(L.l("properties for received messages are read-only."));
        }
    }

    protected void checkBodyWriteable() throws JMSException {
        if (!this._isBodyWriteable) {
            throw new MessageNotWriteableException(L.l("received messages can't be written."));
        }
    }

    protected void checkBodyReadable() throws JMSException {
        if (this._isBodyWriteable) {
            throw new MessageNotReadableException(L.l("write-only messages can't be read until reset() is called."));
        }
    }

    protected void copy(MessageImpl newMsg) {
        if (this._properties != null) {
            newMsg._properties = new HashMap<String, Object>(this._properties);
        }
        newMsg._messageId = this._messageId;
        newMsg._correlationId = this._correlationId;
        newMsg._timestamp = this._timestamp;
        newMsg._expiration = this._expiration;
        newMsg._destination = this._destination;
        newMsg._replyTo = this._replyTo;
        newMsg._deliveryMode = this._deliveryMode;
        newMsg._isRedelivered = this._isRedelivered;
        newMsg._messageType = this._messageType;
        newMsg._priority = this._priority;
    }

    public String toString() {
        if (this._messageId != null) {
            return new StringBuffer().append(this.getClass().getName()).append("[").append(this._messageId).append("]").toString();
        }
        return new StringBuffer().append(this.getClass().getName()).append("@").append(System.identityHashCode(this)).toString();
    }

    public static boolean isReserved(String name) {
        return _reserved.contains(name.toUpperCase());
    }

    static {
        _reserved.add("TRUE");
        _reserved.add("FALSE");
        _reserved.add("NULL");
        _reserved.add("NOT");
        _reserved.add("AND");
        _reserved.add("OR");
        _reserved.add("BETWEEN");
        _reserved.add("LIKE");
        _reserved.add("IN");
        _reserved.add("IS");
        _reserved.add("ESCAPE");
    }
}

