/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class ObjectConverter {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/message/ObjectConverter"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/message/ObjectConverter"));

    public static boolean toBoolean(Object obj) throws JMSException {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null || obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to boolean", obj.getClass().getName()));
    }

    public static byte toByte(Object obj) throws JMSException {
        if (obj instanceof Byte) {
            return ((Number)obj).byteValue();
        }
        if (obj == null || obj instanceof String) {
            return (byte)Long.parseLong((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to byte", obj.getClass().getName()));
    }

    public static short toShort(Object obj) throws JMSException {
        if (obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).shortValue();
        }
        if (obj == null || obj instanceof String) {
            return (short)Long.parseLong((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to short", obj.getClass().getName()));
    }

    public static int toInt(Object obj) throws JMSException {
        if (obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).intValue();
        }
        if (obj == null || obj instanceof String) {
            return (int)Long.parseLong((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to int", obj.getClass().getName()));
    }

    public static long toLong(Object obj) throws JMSException {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).longValue();
        }
        if (obj == null || obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to long", obj.getClass().getName()));
    }

    public static float toFloat(Object obj) throws JMSException {
        if (obj == null || obj instanceof Float) {
            return ((Number)obj).floatValue();
        }
        if (obj == null || obj instanceof String) {
            return (float)Double.parseDouble((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to float", obj.getClass().getName()));
    }

    public static double toDouble(Object obj) throws JMSException {
        if (obj == null || obj instanceof Float || obj instanceof Double) {
            return ((Number)obj).doubleValue();
        }
        if (obj == null || obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        throw new MessageFormatException(L.l("can't convert '{0}' to double", obj.getClass().getName()));
    }

    public static String toString(Object obj) throws JMSException {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static char toChar(Object obj) throws JMSException {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof String) {
            return ((String)obj).charAt(0);
        }
        throw new MessageFormatException(L.l("bad property {0}", obj));
    }

    public static byte[] toBytes(Object obj) throws JMSException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            byte[] newBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            return newBytes;
        }
        if (obj instanceof String) {
            String string = ObjectConverter.toString(obj);
            try {
                return string.getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new MessageFormatException(e.toString());
            }
        }
        throw new MessageFormatException(L.l("can't convert {0} to byte[]", obj.getClass().getName()));
    }
}

