/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import javax.jms.JMSException;
import javax.jms.Message;

public class SpecialIdentifierSelector
extends Selector {
    static final int JMS_DELIVERY_MODE = 1;
    static final int JMS_PRIORITY = 2;
    static final int JMS_MESSAGE_ID = 3;
    static final int JMS_TIMESTAMP = 4;
    static final int JMS_CORRELATION_ID = 5;
    static final int JMS_TYPE = 6;
    private int _type;

    SpecialIdentifierSelector(int type) {
        this._type = type;
    }

    boolean isUnknown() {
        return false;
    }

    boolean isNumber() {
        switch (this._type) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    boolean isString() {
        switch (this._type) {
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    Object evaluate(Message message) throws JMSException {
        switch (this._type) {
            case 1: {
                if (message.getJMSDeliveryMode() == 2) {
                    return "PERSISTENT";
                }
                return "NON_PERSISTENT";
            }
            case 2: {
                return new Integer(message.getJMSPriority());
            }
            case 3: {
                return message.getJMSMessageID();
            }
            case 4: {
                return new Long(message.getJMSTimestamp());
            }
            case 5: {
                return message.getJMSCorrelationID();
            }
            case 6: {
                return message.getJMSType();
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        switch (this._type) {
            case 1: {
                return "JMSDeliveryMode";
            }
            case 2: {
                return "JMSPriority";
            }
            case 3: {
                return "JMSMessageID";
            }
            case 4: {
                return "JMSTimestamp";
            }
            case 5: {
                return "JMSCorrelationID";
            }
            case 6: {
                return "JMSType";
            }
        }
        return "Special[" + this._type + "]";
    }
}

