/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.EnvironmentMBeanServer;
import com.caucho.jmx.EnvironmentMBeanServerBuilder;
import com.caucho.jmx.GlobalMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.JobThread;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jmx {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jmx/Jmx"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jmx/Jmx"));
    private static EnvironmentMBeanServer _mbeanServer;
    private static MBeanServer _globalMBeanServer;

    static void setMBeanServer(EnvironmentMBeanServer server) {
        _mbeanServer = server;
    }

    public static MBeanServer getContextMBeanServer() {
        if (_mbeanServer == null) {
            _mbeanServer = (EnvironmentMBeanServer)EnvironmentMBeanServerBuilder.getGlobal("resin");
        }
        return _mbeanServer;
    }

    public static MBeanServer getGlobalMBeanServer() {
        if (_globalMBeanServer == null) {
            Jmx.getContextMBeanServer();
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            _globalMBeanServer = new GlobalMBeanServer(systemLoader);
        }
        return _globalMBeanServer;
    }

    public static AbstractMBeanServer getMBeanServer() {
        return _mbeanServer;
    }

    public static LinkedHashMap<String, String> copyContextProperties() {
        return _mbeanServer.getContext().copyProperties();
    }

    public static LinkedHashMap<String, String> copyContextProperties(ClassLoader loader) {
        return _mbeanServer.getContext(loader).copyProperties();
    }

    public static void setContextProperties(Map<String, String> properties) {
        _mbeanServer.getContext().setProperties(properties);
    }

    public static void setContextProperties(Map<String, String> properties, ClassLoader loader) {
        _mbeanServer.getContext(loader).setProperties(properties);
    }

    public static ObjectInstance register(Object object, String name) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException, NotCompliantMBeanException {
        if (name.indexOf(58) < 0) {
            LinkedHashMap<String, String> props = Jmx.parseProperties(name);
            if (props.get("type") == null) {
                String type = object.getClass().getName();
                int p = type.lastIndexOf(46);
                if (p > 0) {
                    type = type.substring(p + 1);
                }
                props.put("type", type);
            }
            ObjectName objectName = Jmx.getObjectName("resin", props);
            return Jmx.register(object, objectName);
        }
        return Jmx.register(object, new ObjectName(name));
    }

    public static ObjectInstance register(Object object, Map<String, String> properties) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException, NotCompliantMBeanException {
        LinkedHashMap<String, String> props = Jmx.copyContextProperties();
        props.putAll(properties);
        return Jmx.register(object, Jmx.getObjectName("resin", props));
    }

    public static ObjectInstance register(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return _mbeanServer.registerMBean(Jmx.createMBean(object, name), name);
    }

    public static ObjectInstance register(Object object, ObjectName name, ClassLoader loader) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return _mbeanServer.registerMBean(Jmx.createMBean(object, name), name);
    }

    private static DynamicMBean createMBean(Object obj, ObjectName name) throws NotCompliantMBeanException {
        if (obj == null) {
            throw new NotCompliantMBeanException(L.l("{0} mbean is null", name));
        }
        if (obj instanceof DynamicMBean) {
            return (DynamicMBean)obj;
        }
        Class ifc = Jmx.getMBeanInterface(obj.getClass());
        if (ifc == null) {
            throw new NotCompliantMBeanException(L.l("{0} mbean has no MBean interface", name));
        }
        return new IntrospectionMBean(obj, ifc);
    }

    private static Class getMBeanInterface(Class cl) {
        while (cl != null) {
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> ifc = interfaces[i];
                if (!ifc.getName().endsWith("MBean")) continue;
                return ifc;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public static void unregister(ObjectName name) throws MBeanRegistrationException, InstanceNotFoundException {
        _mbeanServer.unregisterMBean(name);
    }

    public static ObjectInstance register(Object object, String name, Class api) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException, NotCompliantMBeanException {
        return Jmx.register(object, new ObjectName(name), api);
    }

    public static ObjectInstance register(Object object, ObjectName name, Class api) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException, NotCompliantMBeanException {
        IntrospectionMBean mbean = new IntrospectionMBean(object, api);
        return _mbeanServer.registerMBean(mbean, name);
    }

    public static void unregister(String name) throws InstanceNotFoundException, MalformedObjectNameException, MBeanRegistrationException {
        LinkedHashMap<String, String> props = Jmx.copyContextProperties();
        props.put("name", name);
        ObjectName objectName = Jmx.getObjectName("resin", props);
        _mbeanServer.unregisterMBean(objectName);
    }

    public static ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return _mbeanServer.getContext().getObjectName(name);
    }

    public static LinkedHashMap<String, String> parseProperties(String name) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Jmx.parseProperties(map, name);
        return map;
    }

    public static void parseProperties(Map<String, String> properties, String name) {
        Jmx.parseProperties(properties, name, 0);
    }

    private static void parseProperties(Map<String, String> properties, String name, int i) {
        CharBuffer cb = CharBuffer.allocate();
        int len = name.length();
        while (i < len) {
            char ch;
            while (i < len && Character.isWhitespace(name.charAt(i))) {
                ++i;
            }
            cb.clear();
            while (i < len && (ch = name.charAt(i)) != '=' && ch != ',' && !Character.isWhitespace(ch)) {
                cb.append(ch);
                ++i;
            }
            String key = cb.toString();
            if (key.length() == 0) {
                throw new IllegalArgumentException(L.l("`{0}' is an illegal name syntax.", name));
            }
            while (i < len && Character.isWhitespace(name.charAt(i))) {
                ++i;
            }
            if (len <= i || (ch = name.charAt(i)) == ',') {
                properties.put(key, "");
            } else if (ch == '=') {
                ++i;
                while (i < len && Character.isWhitespace(name.charAt(i))) {
                    ++i;
                }
                if (len <= i || (ch = name.charAt(i)) == ',') {
                    properties.put(key, "");
                } else if (ch == '\"' || ch == '\'') {
                    char end = ch;
                    cb.clear();
                    ++i;
                    while (i < len && (ch = name.charAt(i)) != end) {
                        if (ch == '\\') {
                            ch = name.charAt(++i);
                            cb.append(ch);
                        } else {
                            cb.append(ch);
                        }
                        ++i;
                    }
                    if (ch != end) {
                        throw new IllegalArgumentException(L.l("`{0}' is an illegal name syntax.", name));
                    }
                    String value = cb.toString();
                    properties.put(key, value);
                } else {
                    cb.clear();
                    while (i < len && (ch = name.charAt(i)) != ',') {
                        cb.append(ch);
                        ++i;
                    }
                    properties.put(key, cb.toString());
                }
            } else {
                throw new IllegalArgumentException(L.l("`{0}' is an illegal name syntax.", name));
            }
            while (i < len && Character.isWhitespace(name.charAt(i))) {
                ++i;
            }
            if (i < len && name.charAt(i) != ',') {
                throw new IllegalArgumentException(L.l("`{0}' is an illegal name syntax.", name));
            }
            ++i;
        }
    }

    public static ObjectName getObjectName(String domain, Map<String, String> properties) throws MalformedObjectNameException {
        CharBuffer cb = new CharBuffer();
        cb.append(domain);
        cb.append(':');
        boolean isFirst = true;
        for (String key : properties.keySet()) {
            if (!isFirst) {
                cb.append(',');
            }
            isFirst = false;
            cb.append(key);
            cb.append('=');
            String value = properties.get(key);
            if (value.matches("[,=:\"*?]")) {
                value = ObjectName.quote(value);
            }
            cb.append(value);
        }
        return new ObjectName(cb.toString());
    }

    public static Object find(String localName) throws MalformedObjectNameException {
        return Jmx.find(_mbeanServer.getContext().getObjectName(localName));
    }

    public static Object find(ObjectName name) {
        return Jmx.find(name, Thread.currentThread().getContextClassLoader());
    }

    public static Object findGlobal(String localName) throws MalformedObjectNameException {
        return Jmx.findGlobal(_mbeanServer.getContext().getObjectName(localName));
    }

    public static Object findGlobal(ObjectName name) {
        return Jmx.find(name, ClassLoader.getSystemClassLoader());
    }

    public static Object find(ObjectName name, ClassLoader loader) {
        try {
            ObjectInstance obj = _mbeanServer.getObjectInstance(name);
            if (obj == null) {
                return null;
            }
            String className = obj.getClassName();
            Class cl = Class.forName(className, false, loader);
            Class ifc = cl.isInterface() ? cl : Jmx.getMBeanInterface(cl);
            if (ifc == null) {
                return null;
            }
            boolean isBroadcast = true;
            return MBeanServerInvocationHandler.newProxyInstance(_mbeanServer, name, ifc, true);
        }
        catch (InstanceNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public static ArrayList<Object> query(ObjectName namePattern) {
        Set<ObjectName> names = _mbeanServer.queryNames(namePattern, null);
        ArrayList<Object> proxy = new ArrayList<Object>();
        for (ObjectName name : names) {
            proxy.add(Jmx.find(name));
        }
        return proxy;
    }

    public static void queueAbsolute(TimerTask job, long time) {
        JobThread.queue(job, time);
    }

    public static void queueRelative(TimerTask job, long delta) {
        Jmx.queueAbsolute(job, Alarm.getCurrentTime() + delta);
    }

    public static void dequeue(TimerTask job) {
        JobThread.dequeue(job);
    }

    private Jmx() {
    }

    private static void initStaticMBeans() {
        try {
            Class<?> cl = Class.forName("java.lang.Management.ManagementFactory");
            Method method = cl.getMethod("getPlatformMBeanServer", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

