/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.QJspFactory;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspFactory;

public class JspPrecompileResource {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/JspPrecompileResource"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/JspPrecompileResource"));
    private FileSetType _fileSet;
    private Application _application;
    private final Lifecycle _lifecycle = new Lifecycle();

    public void setApplication(Application app) {
        this._application = app;
    }

    public FileSetType createFileSet() {
        if (this._fileSet == null) {
            this._fileSet = new FileSetType();
            this._fileSet.setDir(Vfs.lookup());
        }
        return this._fileSet;
    }

    public void init() throws ConfigException {
        Object owner;
        Path pwd = Vfs.lookup();
        if (this._fileSet == null) {
            this.createFileSet().addInclude(new PathPatternType("**/*.jsp"));
        }
        if (this._application == null && (owner = Environment.getOwner()) instanceof Application) {
            this._application = (Application)owner;
        }
        if (this._application == null) {
            throw new ConfigException(L.l("JspPrecompileResource must be used in a web-app context."));
        }
        this.start();
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory(new QJspFactory());
        }
        JspCompiler compiler = new JspCompiler();
        compiler.setApplication(this._application);
        ArrayList<Path> paths = this._fileSet.getPaths();
        ArrayList<String> classes = new ArrayList<String>();
        String contextPath = this._application.getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        Path pwd = Vfs.lookup();
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.get(i);
            String uri = path.getPath().substring(pwd.getPath().length());
            if (this._application.getContext(contextPath + uri) != this._application) continue;
            String className = JspCompiler.urlToClassName(uri);
            try {
                CauchoPage page = (CauchoPage)compiler.loadClass(className, true);
                LineMap lineMap = new LineMap();
                page.init(lineMap, pwd);
                if (!page._caucho_isModified()) {
                    log.fine("pre-loaded " + uri);
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
            log.fine("compiling " + uri);
            try {
                JspCompilerInstance compilerInst = compiler.getCompilerInstance(path, uri, className);
                JspGenerator generator = compilerInst.generate();
                if (generator.isStatic()) continue;
                LineMap lineMap = generator.getLineMap();
                classes.add(className.replace('.', '/') + ".java");
                continue;
            }
            catch (Exception e) {
                if (e instanceof CompileException) {
                    log.warning(e.getMessage());
                    continue;
                }
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (classes.size() == 0) {
            return;
        }
        try {
            JavaCompiler javaCompiler = JavaCompiler.create(null);
            javaCompiler.setClassDir(compiler.getClassDir());
            String[] files = new String[classes.size()];
            classes.toArray(files);
            javaCompiler.compileBatch(files);
        }
        catch (Exception e) {
            if (e instanceof CompileException) {
                log.warning(e.getMessage());
            }
            log.log(Level.WARNING, e.toString(), e);
        }
    }
}

