/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.AbstractBodyContent;
import com.caucho.jsp.AbstractJspWriter;
import com.caucho.jsp.PageContextImpl;
import com.caucho.server.connection.AbstractResponseStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.jsp.JspWriter;

public class JspWriterAdapter
extends AbstractBodyContent {
    private JspWriter _parent;
    private AbstractResponseStream _out;
    private PageContextImpl _pageContext;
    private boolean _isClosed;

    JspWriterAdapter() {
    }

    void init(PageContextImpl pageContext) {
        this._pageContext = pageContext;
        this._out = null;
        this._isClosed = false;
    }

    void init(JspWriter parent, AbstractResponseStream out) {
        this._parent = parent;
        this._out = out;
        this._isClosed = false;
    }

    public final void write(char[] buf, int offset, int length) throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.print(buf, offset, length);
    }

    public final void write(int ch) throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.print(ch);
    }

    public final void write(String s, int off, int len) throws IOException {
        char[] writeBuffer = this._out.getCharBuffer();
        int size = writeBuffer.length;
        int writeLength = this._out.getCharOffset();
        int end = off + len;
        while (off < end) {
            int sublen = end - off;
            if (size - writeLength < sublen) {
                if (size == writeLength) {
                    writeBuffer = this._out.nextCharBuffer(writeLength);
                    writeLength = 0;
                    if (size < sublen) {
                        sublen = size;
                    }
                } else {
                    sublen = size - writeLength;
                }
            }
            int tail = off + sublen;
            s.getChars(off, tail, writeBuffer, writeLength);
            off = tail;
            writeLength += sublen;
        }
        this._out.setCharOffset(writeLength);
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public int getRemaining() {
        return this._out.getRemaining();
    }

    public void clear() throws IOException {
        if (this._isClosed) {
            return;
        }
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.clearBuffer();
    }

    public void flushBuffer() throws IOException {
        if (this._isClosed) {
            return;
        }
    }

    public void flush() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.flushChar();
    }

    AbstractJspWriter popWriter() {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return super.popWriter();
    }

    public final void close() throws IOException {
        this._isClosed = true;
        this._out = null;
        this._parent = null;
        this._pageContext = null;
    }
}

