/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.types.FileSetType;
import com.caucho.jsp.AnalyzedTag;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.TagAnalyzer;
import com.caucho.jsp.Taglib;
import com.caucho.jsp.TldManager;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.iso_relax.verifier.Schema;

public class TaglibManager {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/TaglibManager"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/TaglibManager"));
    private static ArrayList<TldTaglib> _cauchoTaglibs;
    private Schema _schema;
    private JspResourceManager _resourceManager;
    private Application _application;
    private TldManager _tldManager;
    private String _tldDir;
    private FileSetType _tldFileSet;
    private HashMap<String, String> _uriLocationMap = new HashMap();
    private HashMap<String, TldTaglib> _tldMap = new HashMap();
    private HashMap<String, Taglib> _taglibMap = new HashMap();
    private HashMap<String, Taglib> _taglibDirMap = new HashMap();
    private JspParseException _loadAllTldException;
    private TagAnalyzer _tagAnalyzer = new TagAnalyzer();
    private volatile boolean _isInit;

    public TaglibManager(JspResourceManager resourceManager, Application application) throws JspParseException, IOException {
        this._resourceManager = resourceManager;
        this._application = application;
        this._tldManager = TldManager.create(resourceManager, application);
        try {
            MergePath mergePath = new MergePath();
            mergePath.addClassPath();
            Path schemaPath = mergePath.lookup("com/caucho/jsp/cfg/jsp-tld.rnc");
            if (schemaPath.canRead()) {
                this.setCompactSchema(schemaPath);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new JspParseException(e);
        }
    }

    void setApplication(Application application) {
        this._application = application;
    }

    public void setCompactSchema(Path path) throws JspParseException, IOException {
        ReadStream is = path.openRead();
        try {
            CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
            this._schema = factory.compileSchema(is);
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
        finally {
            is.close();
        }
    }

    public void setTldDir(String tldDir) {
        this._tldDir = tldDir;
    }

    public void setTldFileSet(FileSetType fileSet) {
        this._tldManager.setTldFileSet(fileSet);
    }

    public void addLocationMap(String uri, String location) {
        this._uriLocationMap.put(uri, location);
    }

    public synchronized void init() throws JspParseException, IOException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
    }

    AnalyzedTag analyzeTag(Class cl) {
        return this._tagAnalyzer.analyze(cl);
    }

    public synchronized Taglib getTaglib(String prefix, String uri, String location) throws JspParseException {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new JspParseException(e);
        }
        Taglib taglib = this._taglibMap.get(uri);
        if (taglib != null) {
            return taglib;
        }
        taglib = this.readTaglib(prefix, uri, location);
        if (taglib != null) {
            this._taglibMap.put(uri, taglib);
        }
        return taglib;
    }

    public synchronized Taglib getTaglibDir(String prefix, String dir) throws JspParseException {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new JspParseException(e);
        }
        Taglib taglib = this._taglibDirMap.get(dir);
        if (taglib != null) {
            return taglib;
        }
        TldTaglib tldTaglib = new TldTaglib();
        taglib = new Taglib(prefix, "urn:jsptagdir:" + dir, tldTaglib);
        if (taglib != null) {
            this._taglibDirMap.put(dir, taglib);
        }
        return taglib;
    }

    private Taglib readTaglib(String prefix, String uri, String location) throws JspParseException {
        try {
            TldTaglib tldTaglib = this._tldMap.get(uri);
            if (tldTaglib == null) {
                String mapLocation = this._uriLocationMap.get(uri);
                if (mapLocation != null) {
                    location = mapLocation;
                }
                if (location == null || location.equals("")) {
                    return null;
                }
                tldTaglib = this._tldManager.parseTld(uri, location);
                this._tldMap.put(uri, tldTaglib);
            }
            if (tldTaglib != null) {
                if (tldTaglib.getConfigException() != null) {
                    throw JspParseException.create(tldTaglib.getConfigException());
                }
                return new Taglib(prefix, uri, tldTaglib);
            }
            return null;
        }
        catch (JspParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
    }

    private Path findJar(String location) {
        String sub;
        Path path = location.startsWith("file:") ? Vfs.lookup(location) : (location.startsWith("/") ? this._resourceManager.resolvePath("." + location) : this._resourceManager.resolvePath(location));
        if (path.exists()) {
            return path;
        }
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        String classPath = loader.getClassPath();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            sub = classPath.substring(head, tail);
            path = Vfs.lookup(sub);
            if (sub.endsWith(location) && path.exists()) {
                return path;
            }
            head = tail + 1;
        }
        if (classPath.length() <= head) {
            return null;
        }
        sub = classPath.substring(head);
        path = Vfs.lookup(sub);
        if (sub.endsWith(location) && path.exists()) {
            return path;
        }
        return null;
    }
}

