/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class JspDirectivePage
extends JspNode {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/java/JspDirectivePage"));
    private static final QName IS_EL_IGNORED = new QName("isELIgnored");
    private static final QName IS_VELOCITY_ENABLED = new QName("isVelocityEnabled");
    private static final QName INFO = new QName("info");
    private static final QName CONTENT_TYPE = new QName("contentType");
    private static final QName PAGE_ENCODING = new QName("pageEncoding");
    private static final QName LANGUAGE = new QName("language");
    private static final QName IMPORT = new QName("import");
    private static final QName SESSION = new QName("session");
    private static final QName BUFFER = new QName("buffer");
    private static final QName ERROR_PAGE = new QName("errorPage");
    private static final QName IS_ERROR_PAGE = new QName("isErrorPage");
    private static final QName AUTO_FLUSH = new QName("autoFlush");
    private static final QName IS_THREAD_SAFE = new QName("isThreadSafe");
    private static final QName EXTENDS = new QName("extends");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAttribute(QName name, String value) throws JspParseException {
        if (IS_EL_IGNORED.equals(name)) {
            this._parseState.setELIgnored(value.equals("true"));
            return;
        }
        if (IS_VELOCITY_ENABLED.equals(name)) {
            this._parseState.setVelocityEnabled(value.equals("true"));
            return;
        }
        if (INFO.equals(name)) {
            String oldInfo = this._parseState.getInfo();
            if (oldInfo != null && !value.equals(oldInfo)) {
                throw this.error(L.l("info `{0}' conflicts with previous value of info `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldInfo));
            }
            this._parseState.setInfo(value);
            return;
        }
        if (CONTENT_TYPE.equals(name)) {
            String oldContentType = this._parseState.getContentType();
            if (oldContentType != null && !value.equals(oldContentType)) {
                throw this.error(L.l("contentType `{0}' conflicts with previous value of contentType `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldContentType));
            }
            this._parseState.setContentType(value);
            String charEncoding = JspDirectivePage.parseCharEncoding(value);
            this._parseState.setCharEncoding(charEncoding);
            return;
        }
        if (PAGE_ENCODING.equals(name)) {
            String oldEncoding = this._parseState.getPageEncoding();
            if (oldEncoding != null && !value.equals(oldEncoding)) {
                throw this.error(L.l("pageEncoding `{0}' conflicts with previous value of pageEncoding `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldEncoding));
            }
            this._parseState.setPageEncoding(value);
            return;
        }
        if (LANGUAGE.equals(name)) {
            if (value.equals("java")) return;
            throw this.error(L.l("`{0}' is not supported as a JSP scripting language.", value));
        }
        if (IMPORT.equals(name)) {
            this._parseState.addImport(value);
            return;
        }
        if (SESSION.equals(name)) {
            if (value.equals("true")) {
                this._parseState.setSession(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("session expects `true' or `false' at `{0}'", value));
                this._parseState.setSession(false);
            }
            return;
        }
        if (BUFFER.equals(name)) {
            this._parseState.setBuffer(this.processBufferSize(value));
            return;
        }
        if (ERROR_PAGE.equals(name)) {
            String newErrorPage = this.getRelativeUrl(value);
            this._parseState.setErrorPage(value);
            return;
        }
        if (IS_ERROR_PAGE.equals(name)) {
            if (value.equals("true")) {
                this._parseState.setErrorPage(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("isErrorPage expects `true' or `false' at `{0}'", value));
                this._parseState.setErrorPage(false);
            }
            return;
        }
        if (AUTO_FLUSH.equals(name)) {
            if (value.equals("true")) {
                this._parseState.setAutoFlush(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("autoFlush expects `true' or `false' at `{0}'", value));
                this._parseState.setAutoFlush(false);
            }
            return;
        }
        if (IS_THREAD_SAFE.equals(name)) {
            if (value.equals("true")) {
                this._parseState.setThreadSafe(true);
                return;
            } else {
                if (!value.equals("false")) throw this.error(L.l("isThreadSafe expects `true' or `false' at `{0}'", value));
                this._parseState.setThreadSafe(false);
            }
            return;
        }
        if (!EXTENDS.equals(name)) throw this.error(L.l("`{0}' is an unknown JSP page directive attribute.  See the JSP documentation for a complete list of page directive attributes.", name.getName()));
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(value);
        }
        catch (Exception e) {
            throw this.error(e);
        }
        if (!ClassLiteral.getClass((String)"javax/servlet/jsp/HttpJspPage").isAssignableFrom(cl)) {
            throw this.error(L.l("`{0}' must implement HttpJspPage.  The class named by jsp:directive.page extends='...' must implement HttpJspPage.", value));
        }
        Class oldExtends = this._parseState.getExtends();
        if (oldExtends != null && !value.equals(oldExtends)) {
            throw this.error(L.l("extends `{0}' conflicts with previous value of extends `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldExtends.getName()));
        }
        this._parseState.setExtends(cl);
    }

    private int processBufferSize(String value) throws JspParseException {
        char ch;
        int i;
        if (value.equals("none")) {
            return 0;
        }
        int kb = 0;
        for (i = 0; i < value.length() && (ch = value.charAt(i)) >= '0' && ch <= '9'; ++i) {
            kb = 10 * kb + ch - 48;
        }
        if (!value.substring(i).equals("kb")) {
            throw this.error(L.l("Expected buffer size at '{0}'.  Buffer sizes must end in 'kb'", value));
        }
        return 1024 * kb;
    }

    protected String getRelativeUrl(String value) {
        if (value.length() > 0 && value.charAt(0) == '/') {
            return value;
        }
        return this._parseState.getUriPwd() + value;
    }

    static String parseCharEncoding(String type) throws JspParseException {
        int i;
        type = type.toLowerCase();
        while ((i = type.indexOf(59)) >= 0 && i < type.length()) {
            char ch;
            ++i;
            while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                ++i;
            }
            if (i >= type.length()) {
                return null;
            }
            if ((i = (type = type.substring(i)).indexOf(61)) >= 0) {
                if (!type.startsWith("charset")) continue;
                ++i;
                while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                type = type.substring(i);
            }
            for (i = 0; i < type.length() && (ch = type.charAt(i)) != ';' && ch != ' '; ++i) {
            }
            return type.substring(0, i);
        }
        return null;
    }

    public boolean isStatic() {
        return true;
    }

    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:directive.page");
        if (!this._parseState.isELIgnored()) {
            os.print(" el-ignored='false'");
        }
        os.print("/>");
    }

    public void generate(JspJavaWriter out) throws Exception {
    }
}

