/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.TagInstance;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspContainerNode;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.JspSegmentNode;
import com.caucho.jsp.java.StaticText;
import com.caucho.util.CharBuffer;

public abstract class JspFragmentNode
extends JspContainerNode
implements JspSegmentNode {
    private int _fragmentCode;
    private String _fragmentName;
    private boolean _isValueFragment;
    private boolean _isJspFragment;

    public void endAttributes() throws JspParseException {
        this._fragmentCode = this._gen.uniqueId();
        this._fragmentName = "_jsp_fragment_" + this._fragmentCode;
    }

    public String getFragmentName() {
        return this._fragmentName;
    }

    public String getCustomTagName() {
        return "_jsp_parent_tag";
    }

    public void addText(String text) throws JspParseException {
        this.addChild(new StaticText(this._gen, text, this));
    }

    public boolean isTrim() {
        return false;
    }

    public boolean isStatic() {
        if (this._children == null) {
            return true;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            if (((JspNode)this._children.get(i)).isStatic()) continue;
            return false;
        }
        return true;
    }

    public boolean isValueFragment() {
        return this._isValueFragment;
    }

    public void setJspFragment(boolean isFragment) {
        this._isJspFragment = isFragment;
    }

    public boolean isJspFragment() {
        return this._isJspFragment;
    }

    public void generateFragmentPrologue(JspJavaWriter out) throws Exception {
        if (this._isValueFragment) {
            return;
        }
        this._isJspFragment = true;
        if (this.isStatic()) {
            out.println("com.caucho.jsp.StaticJspFragmentSupport " + this._fragmentName + " = null;");
        } else {
            out.println("_CauchoFragment " + this._fragmentName + " = null;");
        }
    }

    public void generate(JspJavaWriter out) throws Exception {
        this.generateChildren(out);
    }

    protected String generateValue() throws Exception {
        TagInstance parent;
        if (this.isStatic()) {
            return '\"' + JspFragmentNode.escapeJavaString(this.getStaticText()) + '\"';
        }
        this._isValueFragment = true;
        this._gen.addFragment(this);
        CharBuffer cb = CharBuffer.allocate();
        cb.append("_CauchoFragment." + this._fragmentName + "(pageContext, ");
        for (parent = this.getParent().getTag(); parent != null && parent.isTagFileTag(); parent = parent.getParent()) {
        }
        if (parent == null || parent.getId() == TagInstance.TOP_TAG) {
            cb.append("null");
        } else if (parent.getId().startsWith("top_")) {
            cb.append("_jsp_parent_tag");
        } else if (!this.hasCustomTag()) {
            cb.append(parent.getId());
        } else if (parent.isSimpleTag()) {
            cb.append(parent.getId() + "_adapter");
        } else {
            cb.append(parent.getId());
        }
        if (this._gen instanceof JavaTagGenerator) {
            cb.append(", _jspBody");
        } else {
            cb.append(", null");
        }
        cb.append(")");
        return cb.close();
    }

    void generateValueMethod(JspJavaWriter out) throws Exception {
        out.println();
        out.println("static String " + this._fragmentName + "(");
        out.println("  com.caucho.jsp.PageContextImpl pageContext,");
        out.println("  javax.servlet.jsp.tagext.JspTag _jsp_parent_tag,");
        out.println("  javax.servlet.jsp.tagext.JspFragment _jspBody)");
        out.println("  throws Throwable");
        out.println("{");
        out.pushDepth();
        out.println("JspWriter out = pageContext.pushBody();");
        out.println("try {");
        out.pushDepth();
        this.generatePrologue(out);
        this.generate(out);
        out.print("return ((com.caucho.jsp.BodyContentImpl) out)");
        if (this.isTrim()) {
            out.println(".getTrimString();");
        } else {
            out.println(".getString();");
        }
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        out.println("pageContext.popAndReleaseBody();");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }
}

