/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;

public class Functions {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/Functions"));

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj).length;
        }
        return 0;
    }

    public static boolean contains(String whole, String part) {
        if (whole == null) {
            whole = "";
        }
        if (part == null) {
            part = "";
        }
        return whole.indexOf(part) >= 0;
    }

    public static boolean containsIgnoreCase(String whole, String part) {
        if (whole == null) {
            whole = "";
        }
        if (part == null) {
            part = "";
        }
        return (whole = whole.toUpperCase()).indexOf(part = part.toUpperCase()) >= 0;
    }

    public static boolean endsWith(String whole, String part) {
        if (whole == null) {
            whole = "";
        }
        if (part == null) {
            part = "";
        }
        return whole.endsWith(part);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return "";
        }
        CharBuffer cb = CharBuffer.allocate();
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    cb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    cb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    cb.append("&#039;");
                    continue block7;
                }
                case '\"': {
                    cb.append("&#034;");
                    continue block7;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    public static int indexOf(String whole, String part) {
        if (whole == null) {
            whole = "";
        }
        if (part == null) {
            part = "";
        }
        return whole.indexOf(part);
    }

    public static String join(String[] array, String sep) {
        if (array == null) {
            return "";
        }
        if (sep == null) {
            sep = "";
        }
        CharBuffer result = CharBuffer.allocate();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                result.append(sep);
            }
            result.append(array[i]);
        }
        return result.close();
    }

    public static String replace(String input, String before, String after) {
        int next;
        if (input == null) {
            return "";
        }
        if (before == null || before.equals("")) {
            return input;
        }
        if (after == null) {
            after = "";
        }
        CharBuffer result = CharBuffer.allocate();
        int head = 0;
        while ((next = input.indexOf(before, head)) >= 0) {
            result.append(input.substring(head, next));
            result.append(after);
            head = next + before.length();
        }
        result.append(input.substring(head));
        return result.close();
    }

    public static String[] split(String input, String delimiters) {
        if (input == null || input.equals("")) {
            return new String[]{""};
        }
        if (delimiters == null || delimiters.equals("")) {
            return new String[]{input};
        }
        StringTokenizer tokenizer = new StringTokenizer(input, delimiters);
        ArrayList<String> values = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        String[] array = new String[values.size()];
        return values.toArray(array);
    }

    public static boolean startsWith(String whole, String part) {
        if (whole == null) {
            whole = "";
        }
        if (part == null) {
            part = "";
        }
        return whole.startsWith(part);
    }

    public static String substring(String string, int begin, int end) {
        if (string == null || string.equals("")) {
            return "";
        }
        int length = string.length();
        if (begin < 0) {
            begin = 0;
        }
        if (length <= begin) {
            return "";
        }
        if (end < 0 || length < end) {
            end = length;
        }
        if (end <= begin) {
            return "";
        }
        return string.substring(begin, end);
    }

    public static String substringAfter(String whole, String part) {
        if (whole == null || whole.equals("")) {
            return "";
        }
        if (part == null || part.equals("")) {
            return whole;
        }
        int p = whole.indexOf(part);
        if (p < 0) {
            return "";
        }
        return whole.substring(p + part.length());
    }

    public static String substringBefore(String whole, String part) {
        if (whole == null || whole.equals("")) {
            return "";
        }
        if (part == null || part.equals("")) {
            return "";
        }
        int p = whole.indexOf(part);
        if (p < 0) {
            return "";
        }
        return whole.substring(0, p);
    }

    public static String toLowerCase(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        return string.toLowerCase();
    }

    public static String toUpperCase(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        return string.toUpperCase();
    }

    public static String trim(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        return string.trim();
    }
}

