/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl;

import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.jsp.jstl.sql.Result;

public class ResultImpl
implements Result {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/ResultImpl"));
    private ArrayList _rows = new ArrayList();
    private Object[][] _objectRows;
    private SortedMap[] _sortedRows;
    private String[] _columnNames;
    private boolean _isLimitedByMaxRows;

    public ResultImpl(ResultSet rs, int maxRows) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        this._columnNames = new String[columnCount];
        for (int i = 0; i < this._columnNames.length; ++i) {
            this._columnNames[i] = metaData.getColumnName(i + 1);
        }
        if (maxRows < 0) {
            maxRows = Integer.MAX_VALUE;
        }
        while (rs.next() && maxRows-- > 0) {
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            this._rows.add(row);
        }
        if (maxRows == 0) {
            this._isLimitedByMaxRows = true;
        }
    }

    public SortedMap[] getRows() {
        if (this._sortedRows == null) {
            this._sortedRows = new SortedMap[this._rows.size()];
            for (int i = this._rows.size() - 1; i >= 0; --i) {
                TreeMap<String, Object> map;
                this._sortedRows[i] = map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                Object[] row = (Object[])this._rows.get(i);
                for (int j = this._columnNames.length - 1; j >= 0; --j) {
                    map.put(this._columnNames[j], row[j]);
                }
            }
        }
        return this._sortedRows;
    }

    public Object[][] getRowsByIndex() {
        if (this._objectRows == null) {
            this._objectRows = new Object[this._rows.size()][];
            this._rows.toArray((T[])this._objectRows);
        }
        return this._objectRows;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public boolean isLimitedByMaxRows() {
        return this._isLimitedByMaxRows;
    }
}

