/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class CoreSetTag
extends BodyTagSupport {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/CoreSetTag"));
    private Expr valueExpr;
    private String var;
    private String scope;
    private Expr targetExpr;
    private Expr propertyExpr;

    public void setValue(Expr value) {
        this.valueExpr = value;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setTarget(Expr target) {
        this.targetExpr = target;
    }

    public void setProperty(Expr property) {
        this.propertyExpr = property;
    }

    public int doStartTag() throws JspException {
        try {
            if (this.valueExpr == null) {
                return 2;
            }
            VariableResolver env = (VariableResolver)((Object)this.pageContext);
            Object value = this.valueExpr.evalObject(env);
            if (this.var != null) {
                this.setValue(value);
            } else {
                this.setProperty(value);
            }
            return 0;
        }
        catch (Exception e) {
            throw new JspException(e);
        }
    }

    public int doEndTag() throws JspException {
        BodyContent body = this.getBodyContent();
        if (body != null) {
            if (this.var != null) {
                this.setValue(body.getString().trim());
            } else {
                this.setProperty(body.getString().trim());
            }
        }
        return 6;
    }

    private void setValue(Object value) throws JspException {
        if (this.scope == null) {
            if (value != null) {
                this.pageContext.setAttribute(this.var, value);
            } else {
                this.pageContext.removeAttribute(this.var);
            }
        } else if (this.scope.equals("page")) {
            if (value != null) {
                this.pageContext.setAttribute(this.var, value);
            } else {
                this.pageContext.removeAttribute(this.var);
            }
        } else if (this.scope.equals("request")) {
            if (value != null) {
                this.pageContext.getRequest().setAttribute(this.var, value);
            } else {
                this.pageContext.getRequest().removeAttribute(this.var);
            }
        } else if (this.scope.equals("session")) {
            if (value != null) {
                this.pageContext.getSession().setAttribute(this.var, value);
            } else {
                this.pageContext.getSession().removeAttribute(this.var);
            }
        } else if (this.scope.equals("application")) {
            if (value != null) {
                this.pageContext.getServletContext().setAttribute(this.var, value);
            } else {
                this.pageContext.getServletContext().removeAttribute(this.var);
            }
        } else {
            throw new JspException(L.l("illegal scope value {0}", this.scope));
        }
    }

    private void setProperty(Object value) throws JspException {
        try {
            VariableResolver env = (VariableResolver)((Object)this.pageContext);
            Object target = this.targetExpr.evalObject(env);
            String property = this.propertyExpr.evalString(env);
            Expr.setProperty(target, property, value);
        }
        catch (Exception e) {
            throw new JspException(e);
        }
    }

    public static void setValue(PageContext pageContext, String var, String scope, Object value) throws JspException {
        if (var != null) {
            if (scope == null || scope.equals("page")) {
                if (value != null) {
                    pageContext.setAttribute(var, value);
                } else {
                    pageContext.removeAttribute(var);
                }
            } else if (scope.equals("request")) {
                if (value != null) {
                    pageContext.getRequest().setAttribute(var, value);
                } else {
                    pageContext.getRequest().removeAttribute(var);
                }
            } else if (scope.equals("session")) {
                if (value != null) {
                    pageContext.getSession().setAttribute(var, value);
                } else {
                    pageContext.getSession().removeAttribute(var);
                }
            } else if (scope.equals("application")) {
                if (value != null) {
                    pageContext.getServletContext().setAttribute(var, value);
                } else {
                    pageContext.getServletContext().removeAttribute(var);
                }
            } else {
                throw new JspException(L.l("illegal scope value {0}", scope));
            }
        }
    }
}

