/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.jstl.rt.CoreUrlTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.TagSupport;

public class UrlTag
extends TagSupport
implements NameValueTag {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/ImportTag"));
    private Expr valueExpr;
    private Expr contextExpr;
    private String var;
    private String scope;
    private CharBuffer url;

    public void setValue(Expr value) {
        this.valueExpr = value;
    }

    public void setContext(Expr context) {
        this.contextExpr = context;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void addParam(String name, String value) {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        CoreUrlTag.addParam(this.url, name, value, encoding);
    }

    public int doStartTag() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            String value = this.valueExpr.evalString(pageContext);
            String context = null;
            if (this.contextExpr != null) {
                context = this.contextExpr.evalString(pageContext);
            }
            this.url = UrlTag.normalizeURL(pageContext, value, context);
            return 1;
        }
        catch (ELException e) {
            throw new JspException(e);
        }
    }

    public int doEndTag() throws JspException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        String value = UrlTag.encodeURL(pageContext, this.url);
        try {
            if (this.var == null) {
                JspWriter out = pageContext.getOut();
                out.print(value);
            } else {
                CoreSetTag.setValue(pageContext, this.var, this.scope, value);
            }
        }
        catch (IOException e) {
            throw new JspException(e);
        }
        return 6;
    }

    public static CharBuffer normalizeURL(PageContext pageContext, String url, String context) throws JspException {
        if (url == null) {
            url = "";
        }
        CharBuffer value = new CharBuffer();
        int slash = url.indexOf(47);
        int colon = url.indexOf(58);
        if (colon > 0 && colon < slash) {
            value.append(url);
        } else if (slash == 0) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            if (context != null) {
                value.append(context);
                value.append(url);
            } else {
                value.append(request.getContextPath());
                value.append(url);
            }
        } else if (context != null) {
            value.append(context);
            value.append(url);
        } else {
            value.append(url);
        }
        return value;
    }

    public static String encodeURL(PageContext pageContext, CharBuffer url) {
        int slash;
        String value = url.toString();
        int colon = value.indexOf(58);
        if (colon < (slash = value.indexOf(47)) && slash > 0) {
            return value;
        }
        return ((HttpServletResponse)pageContext.getResponse()).encodeURL(value);
    }
}

