/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QDocument;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTransformTag
extends BodyTagSupport
implements NameValueTag {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jstl/el/XmlTransformTag"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/XmlTransformTag"));
    private Expr _xml;
    private Expr _xslt;
    private Expr _xmlSystemId;
    private Expr _xsltSystemId;
    private String _var;
    private String _scope;
    private Expr _result;
    private ArrayList<String> _paramNames = new ArrayList();
    private ArrayList<String> _paramValues = new ArrayList();

    public void setXml(Expr xml) {
        this.setDoc(xml);
    }

    public void setDoc(Expr xml) {
        this._xml = xml;
    }

    public void setXslt(Expr xslt) {
        this._xslt = xslt;
    }

    public void setXmlSystemId(Expr xmlSystemId) {
        this._xmlSystemId = xmlSystemId;
    }

    public void setDocSystemId(Expr xmlSystemId) {
        this._xmlSystemId = xmlSystemId;
    }

    public void setXsltSystemId(Expr xsltSystemId) {
        this._xsltSystemId = xsltSystemId;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setResult(Expr result) {
        this._result = result;
    }

    public void addParam(String name, String value) {
        this._paramNames.add(name);
        this._paramValues.add(value);
    }

    public int doStartTag() throws JspException {
        this._paramNames.clear();
        this._paramValues.clear();
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            Result result;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            JspWriter out = pageContext.getOut();
            TransformerFactory factory = TransformerFactory.newInstance();
            Source source = this.getSource(this._xslt, this._xsltSystemId);
            Transformer transformer = factory.newTransformer(source);
            for (int i = 0; i < this._paramNames.size(); ++i) {
                String name = this._paramNames.get(i);
                String value = this._paramValues.get(i);
                transformer.setParameter(name, value);
            }
            if (this._xml != null) {
                source = this.getSource(this._xml, this._xmlSystemId);
            } else {
                BodyContent bodyContent = this.getBodyContent();
                source = new StreamSource(bodyContent.getReader());
                source.setSystemId(((HttpServletRequest)pageContext.getRequest()).getRequestURI());
            }
            QDocument top = null;
            if (this._result != null) {
                result = (Result)this._result.evalObject(pageContext);
            } else if (this._var != null) {
                top = new QDocument();
                result = new DOMResult(top);
            } else {
                result = new StreamResult(out);
            }
            transformer.transform(source, result);
            if (this._var != null) {
                CoreSetTag.setValue(pageContext, this._var, this._scope, top);
            }
        }
        catch (Exception e) {
            throw new JspException(e);
        }
        return 0;
    }

    private Source getSource(Expr xmlExpr, Expr systemIdExpr) throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            Object xmlObj = xmlExpr.evalObject(pageContext);
            String systemId = null;
            Source source = null;
            if (systemIdExpr != null) {
                systemId = systemIdExpr.evalString(pageContext);
            }
            source = XmlTransformTag.convertToSource(xmlObj, systemId);
            return source;
        }
        catch (ELException e) {
            throw new JspException(e);
        }
    }

    public static Source convertToSource(Object xmlObj, String systemId) throws JspException {
        ArrayList list;
        if (xmlObj instanceof String) {
            ReadStream is = Vfs.openString((String)xmlObj);
            return new StreamSource(is, systemId);
        }
        if (xmlObj instanceof InputStream) {
            return new StreamSource((InputStream)xmlObj, systemId);
        }
        if (xmlObj instanceof Reader) {
            return new StreamSource((Reader)xmlObj, systemId);
        }
        if (xmlObj instanceof Node) {
            return new DOMSource((Node)xmlObj, systemId);
        }
        if (xmlObj instanceof NodeList) {
            return new DOMSource(((NodeList)xmlObj).item(0), systemId);
        }
        if (xmlObj instanceof Source) {
            return (Source)xmlObj;
        }
        if (xmlObj instanceof ArrayList && (list = (ArrayList)xmlObj).size() > 0) {
            return XmlTransformTag.convertToSource(list.get(0), systemId);
        }
        throw new JspException(L.l("unknown xml object type '{0}' '{1}'", xmlObj, xmlObj.getClass()));
    }
}

