/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FmtParseDateTag
extends BodyTagSupport {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/rt/FmtParseDateTag"));
    private String _value;
    private String _type;
    private String _dateStyle;
    private String _timeStyle;
    private Object _parseLocale;
    private String _pattern;
    private Object _timeZone;
    private String _var;
    private String _scope;

    public void setValue(String value) {
        this._value = value;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setDateStyle(String style) {
        this._dateStyle = style;
    }

    public void setTimeStyle(String style) {
        this._timeStyle = style;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public void setTimeZone(Object zone) {
        this._timeZone = zone;
    }

    public void setParseLocale(Object locale) {
        this._parseLocale = locale;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            PageContextImpl pc = (PageContextImpl)this.pageContext;
            JspWriter out = pc.getOut();
            String string = this._value != null ? this._value : this.bodyContent.getString().trim();
            DateFormat format = this.getFormat();
            Date value = format.parse(string);
            if (this._var == null) {
                out.print(value);
            } else {
                CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException e) {
        }
        catch (ParseException e) {
            throw new JspException(e);
        }
        return 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DateFormat getFormat() throws JspException {
        TimeZone timeZone;
        PageContextImpl pc = (PageContextImpl)this.pageContext;
        DateFormat format = null;
        Locale locale = null;
        if (this._parseLocale != null) {
            Object localeObj = this._parseLocale;
            if (localeObj instanceof Locale) {
                locale = (Locale)localeObj;
            } else if (localeObj instanceof String) {
                locale = PageContextImpl.getLocale((String)localeObj);
            }
        }
        if (locale == null) {
            locale = pc.getLocale();
        }
        int dateStyle = 2;
        if (this._dateStyle != null) {
            dateStyle = FmtParseDateTag.getDateStyle(this._dateStyle);
        }
        int timeStyle = 2;
        if (this._timeStyle != null) {
            timeStyle = FmtParseDateTag.getDateStyle(this._timeStyle);
        }
        if (locale != null) {
            if (this._type == null || this._type.equals("date")) {
                format = DateFormat.getDateInstance(dateStyle, locale);
            } else if (this._type.equals("both")) {
                format = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
            } else {
                if (!this._type.equals("time")) throw new JspException(L.l("illegal type `{0}'", this._type));
                format = DateFormat.getTimeInstance(timeStyle, locale);
            }
        } else if (this._type == null || this._type.equals("date")) {
            format = DateFormat.getDateInstance(dateStyle);
        } else if (this._type.equals("both")) {
            format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        } else {
            if (!this._type.equals("time")) throw new JspException(L.l("illegal type `{0}'", this._type));
            format = DateFormat.getTimeInstance(timeStyle);
        }
        if (format == null) {
            return null;
        }
        if (this._pattern != null) {
            try {
                ((SimpleDateFormat)format).applyPattern(this._pattern);
            }
            catch (ClassCastException e) {
                format = new SimpleDateFormat(this._pattern, locale);
            }
        }
        if ((timeZone = this.getTimeZone(this._timeZone)) == null) {
            timeZone = (TimeZone)this.pageContext.getAttribute("com.caucho.time-zone");
        }
        if (timeZone == null) {
            timeZone = this.getTimeZone(Config.find((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.fmt.timeZone"));
        }
        if (timeZone == null) return format;
        format.setTimeZone(timeZone);
        return format;
    }

    private TimeZone getTimeZone(Object timeZoneObj) {
        if (timeZoneObj instanceof TimeZone) {
            return (TimeZone)timeZoneObj;
        }
        if (timeZoneObj instanceof String) {
            String timeZoneString = (String)timeZoneObj;
            return TimeZone.getTimeZone(timeZoneString);
        }
        return null;
    }

    public static int getDateStyle(String style) throws JspException {
        if (style == null || style.equals("default")) {
            return 2;
        }
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("long")) {
            return 1;
        }
        if (style.equals("full")) {
            return 0;
        }
        throw new JspException(L.l("illegal date style `{0}'", style));
    }
}

