/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.make.Dependency;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.security.Permission;
import java.util.ArrayList;

public class Environment {
    private static ArrayList<EnvironmentListener> _globalEnvironmentListeners = new ArrayList();
    private static ArrayList<ClassLoaderListener> _globalLoaderListeners = new ArrayList();

    public static EnvironmentClassLoader getEnvironmentClassLoader() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            return (EnvironmentClassLoader)loader;
        }
        return null;
    }

    public static void addEnvironmentListener(EnvironmentListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addEnvironmentListener(listener, loader);
    }

    public static void addEnvironmentListener(EnvironmentListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalEnvironmentListeners.add(listener);
    }

    public static void removeEnvironmentListener(EnvironmentListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.removeEnvironmentListener(listener, loader);
    }

    public static void removeEnvironmentListener(EnvironmentListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).removeListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalEnvironmentListeners.remove(listener);
    }

    public static void addClassLoaderListener(ClassLoaderListener listener) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addClassLoaderListener(listener, loader);
    }

    public static void addClassLoaderListener(ClassLoaderListener listener, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addListener(listener);
                return;
            }
            loader = loader.getParent();
        }
        _globalLoaderListeners.add(listener);
    }

    public static void init() {
        Environment.init(Thread.currentThread().getContextClassLoader());
    }

    public static void init(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).init();
                return;
            }
            loader = loader.getParent();
        }
        for (int i = 0; i < _globalLoaderListeners.size(); ++i) {
            ClassLoaderListener listener = _globalLoaderListeners.get(i);
            listener.classLoaderInit(null);
        }
    }

    public static void start() {
        Environment.start(Thread.currentThread().getContextClassLoader());
    }

    public static void start(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).start();
                return;
            }
            loader = loader.getParent();
        }
        Environment.init(loader);
        for (int i = 0; i < _globalEnvironmentListeners.size(); ++i) {
            EnvironmentListener listener = _globalEnvironmentListeners.get(i);
            listener.environmentStart(null);
        }
    }

    public static void stop() {
        Environment.stop(Thread.currentThread().getContextClassLoader());
    }

    public static void stop(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).stop();
                return;
            }
            loader = loader.getParent();
        }
        ArrayList<EnvironmentListener> listeners = new ArrayList<EnvironmentListener>();
        listeners.addAll(_globalEnvironmentListeners);
        _globalEnvironmentListeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            EnvironmentListener listener = (EnvironmentListener)listeners.get(i);
            listener.environmentStop(null);
        }
    }

    public static void addDependency(Dependency depend) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addDependency(depend, loader);
    }

    public static void addDependency(Dependency depend, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                ((EnvironmentClassLoader)loader).addDependency(depend);
                return;
            }
            loader = loader.getParent();
        }
    }

    public static DynamicClassLoader getDynamicClassLoader() {
        Thread thread = Thread.currentThread();
        return Environment.getDynamicClassLoader(thread.getContextClassLoader());
    }

    public static DynamicClassLoader getDynamicClassLoader(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return (DynamicClassLoader)loader;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void addDependency(Path path) {
        Environment.addDependency(new Depend(path));
    }

    public static void addDependency(Path path, ClassLoader loader) {
        Environment.addDependency(new Depend(path), loader);
    }

    public static Object getAttribute(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getAttribute(name, loader);
    }

    public static long getDependencyCheckInterval() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            return ((DynamicClassLoader)loader).getDependencyCheckInterval();
        }
        return DynamicClassLoader.getGlobalDependencyCheckInterval();
    }

    public static long getDependencyCheckInterval(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return ((DynamicClassLoader)loader).getDependencyCheckInterval();
            }
            loader = loader.getParent();
        }
        return DynamicClassLoader.getGlobalDependencyCheckInterval();
    }

    public static Object getAttribute(String name, ClassLoader loader) {
        while (loader != null) {
            Object value;
            if (loader instanceof EnvironmentClassLoader && (value = ((EnvironmentClassLoader)loader).getAttribute(name)) != null) {
                return value;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static Object getLevelAttribute(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getLevelAttribute(name, loader);
    }

    public static Object getLevelAttribute(String name, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                return ((EnvironmentClassLoader)loader).getAttribute(name);
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static Object setAttribute(String name, Object value) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.setAttribute(name, value, loader);
    }

    public static Object setAttribute(String name, Object value, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                Object oldValue = envLoader.getAttribute(name);
                envLoader.setAttribute(name, value);
                if (oldValue != null) {
                    return oldValue;
                }
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void addPermission(Permission perm) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Environment.addPermission(perm, loader);
    }

    public static void addPermission(Permission perm, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                envLoader.addPermission(perm);
            }
            loader = loader.getParent();
        }
    }

    public static Object getOwner() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Environment.getOwner(loader);
    }

    public static Object getOwner(ClassLoader loader) {
        while (loader != null) {
            EnvironmentClassLoader envLoader;
            EnvironmentBean owner;
            if (loader instanceof EnvironmentClassLoader && (owner = (envLoader = (EnvironmentClassLoader)loader).getOwner()) != null) {
                return owner;
            }
            loader = loader.getParent();
        }
        return null;
    }

    public static void closeGlobal() {
        ArrayList<ClassLoaderListener> listeners = new ArrayList<ClassLoaderListener>();
        listeners.addAll(_globalLoaderListeners);
        _globalLoaderListeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            ClassLoaderListener listener = (ClassLoaderListener)listeners.get(i);
            listener.classLoaderDestroy(null);
        }
    }
}

