/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryLoader
extends Loader
implements Dependency {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/loader/DirectoryLoader"));
    private Path _path;
    private FileSetType _fileSet;
    private long _lastModified;
    private String[] _fileNames;
    private ArrayList<Path> _pathList = new ArrayList();
    private ArrayList<Path> _newPathList = new ArrayList();
    private ArrayList<JarEntry> _jarList;
    private DependencyContainer _dependencyList = new DependencyContainer();

    public LibraryLoader() {
    }

    public LibraryLoader(Path path) {
        this._path = path;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setFileSet(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        LibraryLoader dirLoader = new LibraryLoader(path);
        loader.addLoader(dirLoader);
        loader.init();
        return loader;
    }

    public void init() throws ConfigException {
        try {
            if (this._fileSet == null) {
                if (this._path.getPath().endsWith(".jar") || this._path.getPath().endsWith(".zip")) {
                    this._fileSet = new FileSetType();
                    this._fileSet.setDir(this._path.getParent());
                    this._fileSet.addInclude(new PathPatternType(this._path.getTail()));
                } else {
                    this._fileSet = new FileSetType();
                    this._fileSet.setDir(this._path);
                    this._fileSet.addInclude(new PathPatternType("*.jar"));
                    this._fileSet.addInclude(new PathPatternType("*.zip"));
                }
            }
            this._jarList = new ArrayList();
            this._dependencyList = new DependencyContainer();
            this.fillJars();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL(this._jarList.get(i).getJarPath());
        }
    }

    @Override
    public void validate() throws ConfigException {
        for (int i = 0; i < this._jarList.size(); ++i) {
            this._jarList.get(i).validate();
        }
    }

    @Override
    public boolean isModified() {
        this._newPathList.clear();
        this._fileSet.getPaths(this._newPathList);
        return !this._newPathList.equals(this._pathList);
    }

    private void fillJars() {
        this._pathList.clear();
        this._jarList.clear();
        this._fileSet.getPaths(this._pathList);
        for (int i = 0; i < this._pathList.size(); ++i) {
            Path jar = this._pathList.get(i);
            this.addJar(jar);
        }
    }

    private void addJar(Path jar) {
        JarPath jarPath = JarPath.create(jar);
        this._jarList.add(new JarEntry(jarPath));
        this._dependencyList.add(new Depend(jarPath));
        if (this.getLoader() != null) {
            this.getLoader().addURL(jarPath);
        }
    }

    @Override
    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        cb.append(head);
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(jar.getContainer().getNativePath());
        }
        return cb.close();
    }

    @Override
    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/');
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        pathName = new StringBuffer().append(pathName).append(".class").toString();
        Object classPath = null;
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
            ClassEntry entry = new ClassEntry(this.getLoader(), name, filePath, filePath, jarEntry.getCodeSource());
            ClassPackage classPackage = jarEntry.getPackage(pkg);
            entry.setClassPackage(classPackage);
            return entry;
        }
        return null;
    }

    @Override
    public void getResources(Vector<URL> vector, String name) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            Path path = jarEntry.getJarPath();
            if (!(path = path.lookup(name)).canRead()) continue;
            try {
                vector.add(new URL(path.getURL()));
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    @Override
    public Path getPath(String pathName) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.exists()) continue;
            return filePath;
        }
        return null;
    }

    public Path getCodePath() {
        return this._fileSet.getDir();
    }

    public String toString() {
        return new StringBuffer().append("LibraryLoader[").append(this._fileSet).append("]").toString();
    }
}

