/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleLoader
extends Loader {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/loader/SimpleLoader"));
    private Path _path;
    private String _prefix;
    private String _pathPrefix;
    private CodeSource _codeSource;

    public SimpleLoader() {
    }

    public SimpleLoader(Path path) {
        this.setPath(path);
    }

    public SimpleLoader(Path path, String prefix) {
        this.setPath(path);
        this.setPrefix(prefix);
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path, String prefix) {
        DynamicClassLoader loader = new DynamicClassLoader(parent, false);
        loader.addLoader(new SimpleLoader(path, prefix));
        loader.init();
        return loader;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path) {
        DynamicClassLoader loader = new DynamicClassLoader(parent, false);
        loader.addLoader(new SimpleLoader(path));
        loader.init();
        return loader;
    }

    public void setPath(Path path) {
        if (path.getPath().endsWith(".jar") || path.getPath().endsWith(".zip")) {
            path = JarPath.create(path);
        }
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
        if (prefix != null) {
            this._pathPrefix = prefix.replace('.', '/');
        }
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        loader.addURL(this._path);
    }

    public void init() throws ConfigException {
        try {
            this._codeSource = new CodeSource(new URL(this._path.getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public Path getPath(String name) {
        if (this._prefix != null && this._pathPrefix == null) {
            this._pathPrefix = this._prefix.replace('.', '/');
        }
        if (this._pathPrefix != null && !name.startsWith(this._pathPrefix)) {
            return null;
        }
        return this._path.lookup(name);
    }

    protected CodeSource getCodeSource(Path path) {
        return this._codeSource;
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this._path instanceof JarPath) {
            cb.append(((JarPath)this._path).getContainer().getNativePath());
        } else if (this._path.isDirectory()) {
            cb.append(this._path.getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        if (this._prefix != null) {
            return "SimpleLoader[" + this._path + ",prefix=" + this._prefix + "]";
        }
        return "SimpleLoader[" + this._path + "]";
    }
}

