/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.EnvironmentLogger;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogManagerImpl
extends LogManager {
    private static final String LOG_LOCAL = "caucho.log.manager";
    private static final HashMap<String, SoftReference<EnvironmentLogger>> _envLoggers = new HashMap();
    private static final EnvironmentLocal<HashMap<String, Logger>> _localLoggers = new EnvironmentLocal();

    public synchronized boolean addLogger(Logger logger) {
        String name = logger.getName();
        EnvironmentLogger envLogger = null;
        SoftReference<EnvironmentLogger> loggerRef = _envLoggers.get(name);
        if (loggerRef != null) {
            envLogger = loggerRef.get();
        }
        if (envLogger == null) {
            envLogger = new EnvironmentLogger(name, logger.getResourceBundleName());
            _envLoggers.put(name, new SoftReference<EnvironmentLogger>(envLogger));
            EnvironmentLogger parent = this.buildParentTree(name);
            if (parent != null) {
                envLogger.setParent(parent);
            }
        }
        if (!logger.getClass().equals(ClassLiteral.getClass((String)"java/util/logging/Logger"))) {
            return envLogger.addLogger(logger);
        }
        return false;
    }

    private EnvironmentLogger buildParentTree(String childName) {
        if (childName.equals("")) {
            return null;
        }
        int p = childName.lastIndexOf(46);
        String parentName = p > 0 ? childName.substring(0, p) : "";
        EnvironmentLogger parent = null;
        SoftReference<EnvironmentLogger> parentRef = _envLoggers.get(parentName);
        if (parentRef != null) {
            parent = parentRef.get();
        }
        if (parent != null) {
            return parent;
        }
        parent = new EnvironmentLogger(parentName, null);
        _envLoggers.put(parentName, new SoftReference<EnvironmentLogger>(parent));
        EnvironmentLogger grandparent = this.buildParentTree(parentName);
        if (grandparent != null) {
            parent.setParent(grandparent);
        }
        return parent;
    }

    public synchronized Logger getLogger(String name) {
        SoftReference<EnvironmentLogger> envLoggerRef = _envLoggers.get(name);
        EnvironmentLogger envLogger = null;
        if (envLoggerRef != null) {
            envLogger = envLoggerRef.get();
        }
        if (envLogger == null) {
            return null;
        }
        Logger customLogger = envLogger.getLogger();
        if (customLogger != null) {
            return customLogger;
        }
        return envLogger;
    }
}

