/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class StreamHandler
extends Handler {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/log/StreamHandler"));
    private WriteStream _os;
    private Formatter _formatter;
    private String _timestamp;

    public StreamHandler(WriteStream os) {
        this._os = os;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        try {
            if (record == null) {
                this._os.println("no record");
                this._os.flush();
                return;
            }
            if (this._formatter != null) {
                this._os.println(this._formatter.format(record));
                this._os.flush();
                return;
            }
            String message = record.getMessage();
            Throwable thrown = record.getThrown();
            if (this._timestamp != null) {
                this._os.print(this._timestamp);
            }
            if (thrown != null) {
                if (message != null && !message.equals(thrown.toString()) && !message.equals(thrown.getMessage())) {
                    this._os.println(message);
                }
                record.getThrown().printStackTrace(this._os.getPrintWriter());
            } else {
                this._os.println(record.getMessage());
            }
            this._os.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public int hashCode() {
        if (this._os == null || this._os.getPath() == null) {
            return super.hashCode();
        }
        return this._os.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StreamHandler)) {
            return false;
        }
        StreamHandler handler = (StreamHandler)o;
        if (this._os == null || handler._os == null) {
            return false;
        }
        return this._os.getPath().equals(handler._os.getPath());
    }
}

