/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyLinkMap<K, V>
implements Map<K, V> {
    protected static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/KeyLinkMap").getName());
    private Map<K, K> _keyLinkMap;
    private Map<K, K> _keyLinkReverseMap;
    private Map<K, V> _map;
    private KeySet _keySet;
    private EntrySet _entrySet;

    public static <K> Map<K, K> getReverseKeyLinkMap(Map<K, K> keyLinkMap) {
        HashMap<K, K> keyLinkReverseMap = new HashMap<K, K>();
        for (Map.Entry<K, K> entry : keyLinkMap.entrySet()) {
            keyLinkReverseMap.put(entry.getValue(), entry.getKey());
        }
        return keyLinkReverseMap;
    }

    public KeyLinkMap(Map<K, V> map, Map<K, K> keyLinkMap, Map<K, K> keyLinkReverseMap) {
        this._map = map;
        this._keyLinkMap = keyLinkMap;
        this._keyLinkReverseMap = keyLinkReverseMap;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    private K getMapKey(K key) {
        K mapKey = key;
        if (this._keyLinkMap != null && (mapKey = this._keyLinkMap.get(key)) == null) {
            mapKey = key;
        }
        return mapKey;
    }

    private K getReverseMapKey(K key) {
        if (this._keyLinkReverseMap == null) {
            return key;
        }
        K mapKey = key;
        mapKey = this._keyLinkReverseMap.get(key);
        if (mapKey == null) {
            mapKey = key;
        }
        return mapKey;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.getMapKey(key));
    }

    @Override
    public V get(Object key) {
        return this._map.get(this.getMapKey(key));
    }

    @Override
    public Set<K> keySet() {
        return this._keySet == null ? (this._keySet = new KeySet()) : this._keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet == null ? (this._entrySet = new EntrySet()) : this._entrySet;
    }

    @Override
    public boolean containsValue(Object v) {
        return this._map.containsValue(v);
    }

    @Override
    public Collection<V> values() {
        return this._map.values();
    }

    @Override
    public V put(K key, V value) {
        return this._map.put(this.getMapKey(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> srcMap) {
        for (Map.Entry<K, V> entry : srcMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this._map.remove(this.getMapKey(key));
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    private Iterator<K> newKeyIterator() {
        if (this._keyLinkMap == null) {
            return this._map.keySet().iterator();
        }
        return new KeyIterator();
    }

    private Iterator<Map.Entry<K, V>> newEntryIterator() {
        if (this._keyLinkMap == null) {
            return this._map.entrySet().iterator();
        }
        return new EntryIterator();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;

        MapEntry(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        public K setKey(K key) {
            K oldKey = this._key;
            this._key = key;
            return oldKey;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> _iterator;

        EntryIterator() {
            this._iterator = KeyLinkMap.this._map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry nextEntry = this._iterator.next();
            Object nextKey = nextEntry.getKey();
            Object mapKey = KeyLinkMap.this.getReverseMapKey(nextEntry.getKey());
            if (mapKey == nextKey) {
                return nextEntry;
            }
            return new MapEntry(mapKey, nextEntry.getValue());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private Iterator<K> _iterator;

        KeyIterator() {
            this._iterator = KeyLinkMap.this._map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public K next() {
            Object next = this._iterator.next();
            Object mapKey = KeyLinkMap.this.getReverseMapKey(next);
            return mapKey;
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return KeyLinkMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            Object value = KeyLinkMap.this.get(other.getKey());
            if (value == null) {
                return other.getValue() == null;
            }
            return value.equals(other.getValue());
        }

        @Override
        public boolean remove(Object o) {
            return KeyLinkMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return KeyLinkMap.this.size();
        }

        @Override
        public void clear() {
            KeyLinkMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return KeyLinkMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return KeyLinkMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return KeyLinkMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return KeyLinkMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            KeyLinkMap.this.clear();
        }
    }
}

