/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.HttpUtil;
import com.caucho.portal.generic.Invocation;
import com.caucho.portal.generic.InvocationFactory;
import com.caucho.portal.generic.InvocationURL;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedInvocationFactory
implements InvocationFactory,
Cloneable {
    protected static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/MapBasedInvocationFactory").getName());
    private String _reservedNamespace = "__";
    private String _actionTargetParameterName = "A";
    private String _windowStateParameterName = "W";
    private String _portletModeParameterName = "M";
    private LinkedHashMap<String, MapBasedInvocation> _invocationMap = new LinkedHashMap();
    private String _actionNamespace;
    private Set<WindowState> _windowStatesUsed;
    private Set<PortletMode> _portletModesUsed;
    private StringBuffer _buffer = new StringBuffer(256);

    public void setReservedNamespace(String namespace) {
        this._reservedNamespace = namespace;
    }

    public String getReservedNamespace() {
        return this._reservedNamespace;
    }

    public void setActionTargetParameterName(String name) {
        this._actionTargetParameterName = name;
    }

    public String getActionTargetParameterName() {
        return this._actionTargetParameterName;
    }

    public void setWindowStateParameterName(String name) {
        this._windowStateParameterName = name;
    }

    public String getWindowStateParameterName() {
        return this._windowStateParameterName;
    }

    public void setPortletModeParameterName(String name) {
        this._portletModeParameterName = name;
    }

    public String getPortletModeParameterName() {
        return this._portletModeParameterName;
    }

    public void start(Map<String, String[]> rawParameters) {
        if (rawParameters != null) {
            this.decodeRawParameters(rawParameters);
        }
    }

    public void finish() {
        this._windowStatesUsed = null;
        this._portletModesUsed = null;
        this._actionNamespace = null;
        this._invocationMap.clear();
    }

    public boolean isActionTarget(String namespace) {
        return namespace == this._actionNamespace;
    }

    protected MapBasedInvocationFactory clone(String namespace) {
        try {
            MapBasedInvocationFactory clone = (MapBasedInvocationFactory)super.clone();
            clone._windowStatesUsed = null;
            clone._portletModesUsed = null;
            clone._actionNamespace = null;
            clone._invocationMap = new LinkedHashMap();
            for (Map.Entry<String, MapBasedInvocation> entry : this._invocationMap.entrySet()) {
                String invocationNamespace = entry.getKey();
                MapBasedInvocation invocation = entry.getValue();
                boolean keepParameters = !namespace.equals(invocationNamespace);
                clone._invocationMap.put(invocationNamespace, invocation.clone(keepParameters));
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void decodeRawParameters(Map<String, String[]> raw) {
        this._buffer.setLength(0);
        StringBuffer buf = this._buffer;
        buf.append(this._reservedNamespace);
        int len = buf.length();
        buf.append(this._reservedNamespace);
        buf.append(this._actionTargetParameterName);
        String actionTargetParameterName = buf.toString();
        buf.setLength(len);
        buf.append(this._windowStateParameterName);
        String windowStateParameterName = buf.toString();
        buf.setLength(len);
        buf.append(this._portletModeParameterName);
        String portletModeParameterName = buf.toString();
        MapBasedInvocation invocation = null;
        String[] action = raw.get(actionTargetParameterName);
        String string = this._actionNamespace = action == null || action.length == 0 ? null : action[0];
        if (this._actionNamespace != null) {
            this.getInvocation(this._actionNamespace);
        }
        Iterator<Map.Entry<String, String[]>> iter = raw.entrySet().iterator();
        while (true) {
            String namespace;
            String[] values;
            String key;
            block11: {
                block7: {
                    block9: {
                        int nd;
                        block10: {
                            block8: {
                                if (!iter.hasNext()) {
                                    return;
                                }
                                Map.Entry<String, String[]> entry = iter.next();
                                key = entry.getKey();
                                values = entry.getValue();
                                namespace = null;
                                if (!key.startsWith(this._reservedNamespace)) break block7;
                                int keyLen = key.length();
                                int st = this._reservedNamespace.length();
                                nd = key.indexOf(46, st);
                                if (nd <= -1) break block8;
                                namespace = key.substring(st, nd);
                                if (++nd >= keyLen) break block9;
                                break block10;
                            }
                            if (!log.isLoggable(Level.FINE) || key.equals(actionTargetParameterName)) continue;
                            log.fine(new StringBuffer().append("unusable raw parameter name `").append(key).append("'").toString());
                            continue;
                        }
                        key = key.substring(nd);
                        break block11;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(new StringBuffer().append("unusable . raw parameter name `").append(key).append("'").toString());
                    continue;
                }
                if (this._actionNamespace == null) {
                    log.finer(new StringBuffer().append("unusable raw action parameter name `").append(key).append("'").toString());
                    continue;
                }
                namespace = this._actionNamespace;
            }
            if (invocation == null || !invocation.getNamespace().equals(namespace)) {
                invocation = this.getInvocation(namespace);
            }
            if (windowStateParameterName.equals(key)) {
                invocation.setWindowStateName(values);
                continue;
            }
            if (portletModeParameterName.equals(key)) {
                invocation.setPortletModeName(values);
                continue;
            }
            invocation.getParameterMap().put(key, values);
        }
    }

    public String getURL() {
        String key;
        this._buffer.setLength(0);
        StringBuffer buf = this._buffer;
        StringBuffer url = this._buffer;
        if (this._actionNamespace != null) {
            this.appendReserved(url, null, this._actionTargetParameterName, this._actionNamespace);
        }
        Iterator<Map.Entry<String, MapBasedInvocation>> iter = this._invocationMap.entrySet().iterator();
        String viewPortletModeNamespace = null;
        String normalWindowStateNamespace = null;
        boolean needViewPortletMode = false;
        boolean needNormalWindowState = false;
        boolean sawActionNamespace = false;
        while (iter.hasNext()) {
            String value;
            String key2;
            boolean hasParameters;
            Map.Entry<String, MapBasedInvocation> entry = iter.next();
            String namespace = entry.getKey();
            MapBasedInvocation invocation = entry.getValue();
            String paramNamespace = namespace == this._actionNamespace ? null : namespace;
            PortletMode portletMode = invocation.getPortletMode();
            WindowState windowState = invocation.getWindowState();
            Map parameterMap = invocation._parameterMap;
            boolean bl = hasParameters = parameterMap != null && !parameterMap.isEmpty();
            if (portletMode == PortletMode.VIEW) {
                if (viewPortletModeNamespace == null && !hasParameters) {
                    viewPortletModeNamespace = namespace;
                }
            } else {
                needViewPortletMode = true;
                key2 = this._portletModeParameterName;
                value = portletMode.toString();
                this.appendReserved(url, namespace, key2, value);
            }
            if (windowState == WindowState.NORMAL) {
                if (normalWindowStateNamespace == null && !hasParameters) {
                    normalWindowStateNamespace = namespace;
                }
            } else {
                needNormalWindowState = true;
                key2 = this._windowStateParameterName;
                value = windowState.toString();
                this.appendReserved(url, namespace, key2, value);
            }
            if (parameterMap == null || parameterMap.isEmpty()) continue;
            for (Map.Entry paramEntry : parameterMap.entrySet()) {
                String paramKey = (String)paramEntry.getKey();
                String[] paramValues = (String[])paramEntry.getValue();
                if (paramValues == null || paramValues.length == 0) continue;
                this.appendParameter(url, paramNamespace, paramKey, paramValues);
            }
        }
        if (needViewPortletMode && viewPortletModeNamespace != null) {
            key = this._portletModeParameterName;
            if (viewPortletModeNamespace == this._actionNamespace) {
                viewPortletModeNamespace = null;
            }
            this.appendReserved(url, viewPortletModeNamespace, key, "view");
        }
        if (needNormalWindowState && normalWindowStateNamespace != null) {
            key = this._windowStateParameterName;
            if (normalWindowStateNamespace == this._actionNamespace) {
                normalWindowStateNamespace = null;
            }
            this.appendReserved(url, normalWindowStateNamespace, key, "normal");
        }
        return url.toString();
    }

    private void appendReserved(StringBuffer url, String namespace, String key, String value) {
        url.append(url.length() == 0 ? (char)'?' : '&');
        url.append(this._reservedNamespace);
        if (namespace != null) {
            url.append(namespace);
            url.append('.');
        }
        url.append(this._reservedNamespace);
        url.append(key);
        url.append('=');
        HttpUtil.encode(value, url);
    }

    private void appendParameter(StringBuffer url, String namespace, String key, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            url.append(url.length() == 0 ? (char)'?' : '&');
            if (namespace != null) {
                url.append(this._reservedNamespace);
                url.append(namespace);
                url.append('.');
            }
            HttpUtil.encode(key, url);
            url.append('=');
            HttpUtil.encode(values[i], url);
        }
    }

    @Override
    public Set<WindowState> getWindowStatesUsed() {
        if (this._windowStatesUsed == null) {
            this._windowStatesUsed = new HashSet<WindowState>();
            if (this._invocationMap != null) {
                for (Map.Entry<String, MapBasedInvocation> entry : this._invocationMap.entrySet()) {
                    this._windowStatesUsed.add(entry.getValue().getWindowState());
                }
            }
        }
        if (this._windowStatesUsed.isEmpty()) {
            this._windowStatesUsed.add(WindowState.NORMAL);
        }
        return this._windowStatesUsed;
    }

    private void addWindowStateUsed(WindowState windowState) {
        if (this._windowStatesUsed != null) {
            this._windowStatesUsed.add(windowState);
        }
    }

    @Override
    public Set<PortletMode> getPortletModesUsed() {
        if (this._portletModesUsed == null) {
            this._portletModesUsed = new HashSet<PortletMode>();
            if (this._invocationMap != null) {
                for (Map.Entry<String, MapBasedInvocation> entry : this._invocationMap.entrySet()) {
                    this._portletModesUsed.add(entry.getValue().getPortletMode());
                }
            }
        }
        if (this._portletModesUsed.isEmpty()) {
            this._portletModesUsed.add(PortletMode.VIEW);
        }
        return this._portletModesUsed;
    }

    private void addPortletModeUsed(PortletMode portletMode) {
        if (this._portletModesUsed != null) {
            this._portletModesUsed.add(portletMode);
        }
    }

    @Override
    public MapBasedInvocation getInvocation(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace cannot be null");
        }
        MapBasedInvocation invocation = this._invocationMap.get(namespace);
        if (invocation == null) {
            invocation = new MapBasedInvocation(this);
            invocation.start(namespace);
            this._invocationMap.put(namespace, invocation);
        }
        return invocation;
    }

    protected InvocationURL createActionURL(String namespace) {
        MapBasedInvocationFactory clone = this.clone(namespace);
        clone._actionNamespace = namespace;
        return new MapBasedInvocationURL(clone, namespace);
    }

    protected InvocationURL createRenderURL(String namespace) {
        MapBasedInvocationFactory clone = this.clone(namespace);
        clone._actionNamespace = null;
        return new MapBasedInvocationURL(clone, namespace);
    }

    public String toString() {
        return new StringBuffer().append("[MapBasedInvocationFactory actionNamespace=").append(this._actionNamespace).append(" invocationMap=").append(this._invocationMap).append("]").toString();
    }

    static class MapBasedInvocationURL
    extends InvocationURL {
        MapBasedInvocationFactory _factory;

        MapBasedInvocationURL(MapBasedInvocationFactory factory, String namespace) {
            super(factory, namespace);
            this._factory = factory;
        }

        public String getURL() {
            return this._factory.getURL();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapBasedInvocation
    implements Invocation,
    Cloneable {
        private MapBasedInvocationFactory _factory;
        private String _namespace;
        private WindowState _windowState = WindowState.NORMAL;
        private PortletMode _portletMode = PortletMode.VIEW;
        private Map<String, String[]> _parameterMap;

        public MapBasedInvocation(MapBasedInvocationFactory factory) {
            this._factory = factory;
        }

        public void start(String namespace) {
            if (this._namespace != null) {
                throw new IllegalStateException("missing finish()?");
            }
            this._namespace = namespace;
        }

        public void finish() {
            this._windowState = WindowState.NORMAL;
            this._portletMode = PortletMode.VIEW;
            if (this._parameterMap != null) {
                this._parameterMap.clear();
            }
            this._namespace = null;
        }

        public MapBasedInvocation clone(boolean keepParameters) {
            try {
                MapBasedInvocation clone = (MapBasedInvocation)super.clone();
                clone._parameterMap = keepParameters && this._parameterMap != null ? new LinkedHashMap<String, String[]>(this._parameterMap) : null;
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getNamespace() {
            return this._namespace;
        }

        @Override
        public boolean isActionTarget() {
            return this._factory.isActionTarget(this._namespace);
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            if (this._parameterMap == null) {
                this._parameterMap = new LinkedHashMap<String, String[]>();
            }
            return this._parameterMap;
        }

        @Override
        public Map<String, String[]> releaseParameterMap() {
            Map<String, String[]> map = this.getParameterMap();
            this._parameterMap = null;
            return map;
        }

        @Override
        public WindowState getWindowState() {
            return this._windowState;
        }

        @Override
        public void setWindowState(WindowState windowState) {
            this._windowState = windowState == null ? WindowState.NORMAL : windowState;
            this._factory.addWindowStateUsed(this._windowState);
        }

        void setWindowStateName(String[] values) {
            String windowStateName;
            String string = windowStateName = values == null || values.length == 0 ? null : values[0];
            if (windowStateName == null) {
                this.setWindowState(WindowState.NORMAL);
            } else if (windowStateName.equals("normal")) {
                this.setWindowState(WindowState.NORMAL);
            } else if (windowStateName.equals("minimized")) {
                this.setWindowState(WindowState.MINIMIZED);
            } else if (windowStateName.equals("maximized")) {
                this.setWindowState(WindowState.MAXIMIZED);
            } else {
                this.setWindowState(new WindowState(windowStateName));
            }
        }

        @Override
        public PortletMode getPortletMode() {
            return this._portletMode;
        }

        @Override
        public void setPortletMode(PortletMode portletMode) {
            this._portletMode = portletMode == null ? PortletMode.VIEW : portletMode;
            this._factory.addPortletModeUsed(this._portletMode);
        }

        void setPortletModeName(String[] values) {
            String portletModeName;
            String string = portletModeName = values == null || values.length == 0 ? null : values[0];
            if (portletModeName == null) {
                this.setPortletMode(PortletMode.VIEW);
            } else if (portletModeName.equals("view")) {
                this.setPortletMode(PortletMode.VIEW);
            } else if (portletModeName.equals("edit")) {
                this.setPortletMode(PortletMode.EDIT);
            } else if (portletModeName.equals("help")) {
                this.setPortletMode(PortletMode.HELP);
            } else {
                this.setPortletMode(new PortletMode(portletModeName));
            }
        }

        @Override
        public InvocationURL createActionURL() {
            return this._factory.createActionURL(this._namespace);
        }

        @Override
        public InvocationURL createRenderURL() {
            return this._factory.createRenderURL(this._namespace);
        }

        public String toString() {
            return new StringBuffer().append("[MapBasedInvocationFactory  namespace=").append(this._namespace).append(" windowState=").append(this._windowState).append(" portletMode=").append(this._portletMode).append(" parameters=").append(this._parameterMap).append("]").toString();
        }
    }
}

