/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.InvocationURL;
import com.caucho.portal.generic.context.ConnectionContext;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalURL
implements PortletURL {
    private ConnectionContext _context;
    private InvocationURL _invocationURL;
    private String _url;

    public PortalURL(ConnectionContext context, InvocationURL invocationURL) {
        this._context = context;
        this._invocationURL = invocationURL;
    }

    protected void checkWindowState(String namespace, WindowState windowState) throws WindowStateException {
        if (!this._context.isWindowStateAllowed(namespace, windowState)) {
            throw new WindowStateException(new StringBuffer().append("WindowState `").append(windowState).append("' not allowed for namespace `").append(namespace).append("'").toString(), windowState);
        }
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        this._url = null;
        this.checkWindowState(this._invocationURL.getNamespace(), windowState);
        this._invocationURL.setWindowState(windowState);
    }

    public void setWindowState(String namespace, WindowState windowState) throws WindowStateException {
        this._url = null;
        this.checkWindowState(namespace, windowState);
        this._invocationURL.setWindowState(namespace, windowState);
    }

    protected void checkPortletMode(String namespace, PortletMode portletMode) throws PortletModeException {
        if (!this._context.isPortletModeAllowed(namespace, portletMode)) {
            throw new PortletModeException(new StringBuffer().append("PortletMode `").append(portletMode).append("' not allowed for namespace `").append(namespace).append("'").toString(), portletMode);
        }
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        this._url = null;
        this.checkPortletMode(this._invocationURL.getNamespace(), portletMode);
        this._invocationURL.setPortletMode(portletMode);
    }

    public void setPortletMode(String namespace, PortletMode portletMode) throws PortletModeException {
        this._url = null;
        this.checkPortletMode(namespace, portletMode);
        this._invocationURL.setPortletMode(namespace, portletMode);
    }

    public void setParameters(Map parameters) {
        this._url = null;
        this._invocationURL.setParameters(parameters);
    }

    public void setParameter(String name, String value) {
        this._url = null;
        this._invocationURL.setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        this._url = null;
        this._invocationURL.setParameter(name, values);
    }

    public void setParameter(String namespace, String name, String value) {
        this._url = null;
        this._invocationURL.setParameter(namespace, name, value);
    }

    public void setParameter(String namespace, String name, String[] values) {
        this._url = null;
        this._invocationURL.setParameter(namespace, name, values);
    }

    public void setParameters(String namespace, Map<String, String[]> parameters) {
        this._url = null;
        this._invocationURL.setParameters(namespace, parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this._url = null;
        this._invocationURL.setSecure(secure);
        if (secure) {
            this.getURL();
        }
    }

    protected boolean isSecureSpecified() {
        return this._invocationURL.isSecureSpecified();
    }

    protected boolean isSecure() {
        return this._invocationURL.isSecure();
    }

    protected String getURL() throws PortletSecurityException {
        if (this._url != null) {
            return this._url;
        }
        String url = this._invocationURL.getURL();
        this._url = this.isSecureSpecified() ? this._context.resolveURL(url, this.isSecure()) : this._context.resolveURL(url);
        return this._url;
    }

    public String toString() {
        try {
            return this.getURL();
        }
        catch (PortletSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }
}

