/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionPreferences
extends LinkedHashMap<String, String[]>
implements Serializable,
HttpSessionBindingListener,
HttpSessionActivationListener {
    transient WeakReference _sessionRef;
    private transient boolean _isUpdateNeeded;
    private String _sessionAttributeName;

    @Override
    public void valueBound(HttpSessionBindingEvent event) {
        if (this._sessionRef == null) {
            this._sessionRef = new WeakReference<HttpSession>(event.getSession());
            this._sessionAttributeName = event.getName();
        }
    }

    @Override
    public void valueUnbound(HttpSessionBindingEvent event) {
        this._sessionRef = null;
        this._sessionAttributeName = null;
    }

    @Override
    public void sessionDidActivate(HttpSessionEvent event) {
        this._sessionRef = new WeakReference<HttpSession>(event.getSession());
    }

    @Override
    public void sessionWillPassivate(HttpSessionEvent event) {
    }

    @Override
    public String[] put(String key, String[] value) {
        this._isUpdateNeeded = true;
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSessionIfNeeded() {
        HttpSession session;
        if (this._isUpdateNeeded && this._sessionRef != null && (session = (HttpSession)this._sessionRef.get()) != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                session.setAttribute(this._sessionAttributeName, this);
                this._isUpdateNeeded = false;
            }
        }
    }
}

