/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.relaxng.CompactParser;
import com.caucho.relaxng.SchemaImpl;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompactVerifierFactoryImpl
extends VerifierFactory {
    private static HashMap<String, SoftReference<Schema>> _schemaMap = new HashMap();

    public static Schema compileFromResource(String schemaName) throws VerifierConfigurationException, SAXException, IOException {
        CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
        MergePath mp = new MergePath();
        mp.addClassPath();
        return factory.compileSchema(mp.lookup(schemaName));
    }

    public static Schema compileFromPath(Path path) throws VerifierConfigurationException, SAXException, IOException {
        return new CompactVerifierFactoryImpl().compileSchema(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema compileSchema(Path path) throws VerifierConfigurationException, SAXException, IOException {
        String nativePath = path.getNativePath();
        SoftReference<Schema> schemaRef = _schemaMap.get(nativePath);
        Schema schema = null;
        if (schemaRef != null && (schema = schemaRef.get()) != null) {
            return schema;
        }
        ReadStream is = path.openRead();
        try {
            InputSource source = new InputSource(is);
            source.setSystemId(path.getUserPath());
            schema = this.compileSchema(source);
            if (schema != null) {
                _schemaMap.put(nativePath, new SoftReference<Schema>(schema));
            }
        }
        finally {
            is.close();
        }
        return schema;
    }

    public Schema compileSchema(InputSource is) throws VerifierConfigurationException, SAXException, IOException {
        try {
            CompactParser parser = new CompactParser();
            parser.parse(is);
            SchemaImpl schema = new SchemaImpl(parser.getGrammar());
            schema.setFilename(is.getSystemId());
            return schema;
        }
        catch (Exception e) {
            throw new VerifierConfigurationException(e);
        }
    }
}

