/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.log.Log;
import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.SchemaImpl;
import com.caucho.relaxng.VerifierImpl;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.xml.QName;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.iso_relax.verifier.VerifierHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierHandlerImpl
extends DefaultHandler
implements VerifierHandler {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/relaxng/VerifierHandlerImpl"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/relaxng/VerifierHandlerImpl"));
    private SchemaImpl _schema;
    private VerifierImpl _verifier;
    private boolean _hasProgram;
    private boolean _isValid = true;
    private LruCache<Object, Item> _programCache;
    private QName _name;
    private ArrayList<QName> _nameStack = new ArrayList();
    private String _eltLocation;
    private ArrayList<String> _eltLocationStack = new ArrayList();
    private Item _item;
    private ArrayList<Item> _itemStack = new ArrayList();
    private Locator _locator;
    private boolean _isLogFinest;
    private CharBuffer _text = new CharBuffer();
    private boolean _hasText;
    private StartKey _startKey = new StartKey();
    private EndElementKey _endElementKey = new EndElementKey();

    public VerifierHandlerImpl(SchemaImpl schema, VerifierImpl verifier) {
        this._schema = schema;
        this._programCache = this._schema.getProgramCache();
        this._verifier = verifier;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) throws SAXException {
        this._verifier.setErrorHandler(errorHandler);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this._nameStack.clear();
            this._itemStack.clear();
            this._eltLocationStack.clear();
            this._name = new QName("#top", "");
            this._item = this._schema.getStartItem();
            this._itemStack.add(this._item);
            this._eltLocation = this.getLocation();
            this._isLogFinest = log.isLoggable(Level.FINEST);
            this._hasText = false;
            this._text.clear();
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (!this._isValid) {
            return;
        }
        if (this._hasText) {
            this.sendText();
        }
        if (this._isLogFinest) {
            log.finest(new StringBuffer().append("element start: ").append(qName).toString());
        }
        try {
            QName name;
            QName parent = this._name;
            this._nameStack.add(parent);
            String parentLocation = this._eltLocation;
            this._eltLocationStack.add(parentLocation);
            this._name = name = new QName(qName, uri);
            this._eltLocation = this.getLocation();
            Item newItem = this.getStartElement(this._item, name);
            if (newItem == null) {
                Item parentItem = this._itemStack.get(this._itemStack.size() - 1);
                if (parent.getName().equals("#top")) {
                    throw new RelaxException(L.l("<{0}> is an unexpected top-level tag.{1}", (Object)qName, this.errorMessageDetail(this._item, parentItem, null, name)));
                }
                throw new RelaxException(L.l("<{0}> is an unexpected tag (parent <{1}> starts at {2}).{3}", qName, parent.getName(), parentLocation, this.errorMessageDetail(this._item, parentItem, parent.getName(), name)));
            }
            this._item = newItem;
            this._itemStack.add(newItem);
            Item parentItem = newItem;
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String attrUri = attrs.getURI(i);
                String attrQName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (this._isLogFinest) {
                    log.finest(new StringBuffer().append("attribute: ").append(attrQName).append("=\"").append(value).append("\"").toString());
                }
                name = new QName(attrQName, attrUri);
                if (!attrQName.startsWith("xml:")) {
                    if (!this._item.allowAttribute(name, value)) {
                        throw new RelaxException(L.l("{0}=\"{1}\" is an unexpected attribute in <{2}>.{3}", attrQName, value, qName, this.attributeMessageDetail(this._item, parentItem, qName, null)));
                    }
                    this._item = this._item.setAttribute(name, value);
                }
                if (this._item != null) continue;
                this._item = EmptyItem.create();
            }
            newItem = this._item.attributeEnd();
            if (newItem == null) {
                throw new RelaxException(L.l("<{0}> expects more attributes.{1}", (Object)qName, this.attributeMessageDetail(this._item, parentItem, qName, null)));
            }
            this._item = newItem;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private Item getStartElement(Item item, QName name) throws RelaxException {
        this._startKey.init(item, name);
        Item newItem = this._programCache.get(this._startKey);
        if (newItem != null) {
            return newItem;
        }
        newItem = this._item.startElement(name);
        if (newItem != null) {
            this._programCache.put(new StartKey(item, name), newItem);
        }
        return newItem;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._hasText = true;
        this._text.append(ch, start, length);
    }

    public void sendText() throws SAXException {
        if (!this._hasText) {
            return;
        }
        this._hasText = false;
        String string = this._text.toString();
        this._text.clear();
        try {
            Item newItem = this._item.text(string);
            if (newItem == null) {
                Item parentItem = this._itemStack.get(this._itemStack.size() - 1);
                throw new RelaxException(L.l("The following text is not allowed in this context.\n{0}\n{1}", (Object)string, this.errorMessageDetail(this._item, parentItem, this._name.getName(), null)));
            }
            this._item = newItem;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        QName parent;
        if (this._hasText) {
            this.sendText();
        }
        if (!this._isValid) {
            return;
        }
        if (this._isLogFinest) {
            log.finest(new StringBuffer().append("element end: ").append(qName).toString());
        }
        QName name = this._name;
        this._name = parent = this._nameStack.remove(this._nameStack.size() - 1);
        Item parentItem = this._itemStack.remove(this._itemStack.size() - 1);
        String eltOpen = this._eltLocation;
        this._eltLocation = this._eltLocationStack.remove(this._eltLocationStack.size() - 1);
        try {
            Item nextItem = this.getEndElement(this._item);
            if (nextItem == null) {
                throw new RelaxException(L.l("<{0}> closed while expecting more elements (open at {1}).{2}", qName, eltOpen, this.requiredMessageDetail(this._item, parentItem, qName, null)));
            }
            this._item = nextItem;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private Item getEndElement(Item item) throws RelaxException {
        this._endElementKey.init(item);
        Item newItem = this._programCache.get(this._endElementKey);
        if (newItem != null) {
            return newItem;
        }
        newItem = this._item.endElement();
        if (newItem != null) {
            this._programCache.put(new EndElementKey(item), newItem);
        }
        return newItem;
    }

    private void error(SAXException e) throws SAXException {
        this._isValid = false;
        this._verifier.error(new SAXParseException(e.getMessage(), this._locator));
    }

    private void error(Exception e) throws SAXException {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof SAXException) {
            this.error((SAXException)e);
        } else {
            this.error(new SAXException(e.getMessage(), e));
        }
    }

    private String errorMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        HashSet<QName> values = new HashSet<QName>();
        currentItem.firstSet(values);
        String expected = null;
        if (values.size() <= 5) {
            expected = this.namesToString(values, parentName, qName, currentItem.allowEmpty());
        }
        return this.syntaxMessage(item, parentItem, parentName, qName, expected);
    }

    private String requiredMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        HashSet<QName> values = new HashSet<QName>();
        currentItem.requiredFirstSet(values);
        String expected = null;
        if (values.size() <= 5) {
            expected = this.namesToString(values, parentName, qName, currentItem.allowEmpty());
        }
        return this.syntaxMessage(item, parentItem, parentName, qName, expected);
    }

    private String attributeMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        String allowed = this.allowedAttributes(currentItem, qName);
        return this.syntaxMessage(item, parentItem, parentName, qName, allowed);
    }

    private String syntaxMessage(Item item, Item parentItem, String parentName, QName qName, String expected) {
        String prefix;
        String syntaxPrefix = parentName == null || parentName.equals("#top") ? "Syntax: " : new StringBuffer().append("<").append(parentName).append("> syntax: ").toString();
        String msg = "";
        Item topParent = null;
        for (Item parent = item; parent != null; parent = parent.getParent()) {
            if (qName == null || !parent.allowsElement(qName)) continue;
            msg = " Check for duplicate and out-of-order tags.";
            if (expected != null) {
                msg = new StringBuffer().append(msg).append(expected).append("\n").toString();
            }
            msg = new StringBuffer().append(msg).append("\n").toString();
            String prefix2 = "Syntax: ";
            if (parent == parentItem) {
                prefix2 = syntaxPrefix;
            }
            msg = new StringBuffer().append(msg).append(prefix2).append(parent.toSyntaxDescription(prefix2.length())).toString();
            break;
        }
        if (topParent == null || topParent instanceof EmptyItem) {
            topParent = parentItem;
            if (qName != null && topParent.allowsElement(qName)) {
                msg = " Check for duplicate and out-of-order tags.";
                if (expected != null) {
                    msg = new StringBuffer().append(msg).append(expected).append("\n").toString();
                }
                msg = new StringBuffer().append(msg).append("\n").toString();
                prefix = syntaxPrefix;
                msg = new StringBuffer().append(msg).append(prefix).append(topParent.toSyntaxDescription(prefix.length())).toString();
            }
        }
        if (msg.equals("")) {
            msg = "";
            if (expected != null) {
                msg = new StringBuffer().append(msg).append(expected).append("\n").toString();
            }
            msg = new StringBuffer().append(msg).append("\n").toString();
            prefix = syntaxPrefix;
            msg = new StringBuffer().append(msg).append(prefix).append(topParent.toSyntaxDescription(prefix.length())).toString();
        }
        return msg;
    }

    private String requiredValues(Item item, String parentName, QName qName) {
        if (item == null) {
            return "";
        }
        HashSet<QName> values = new HashSet<QName>();
        item.requiredFirstSet(values);
        return this.namesToString(values, parentName, qName, item.allowEmpty());
    }

    private String namesToString(HashSet<QName> values, String parentName, QName qName, boolean allowEmpty) {
        CharBuffer cb = new CharBuffer();
        if (values.size() > 0) {
            ArrayList<QName> sortedValues = new ArrayList<QName>(values);
            Collections.sort(sortedValues);
            for (int i = 0; i < sortedValues.size(); ++i) {
                QName name = sortedValues.get(i);
                if (i == 0) {
                    cb.append("\n\n");
                } else if (i == sortedValues.size() - 1) {
                    cb.append(" or\n");
                } else {
                    cb.append(",\n");
                }
                if (name.getName().equals("#text")) {
                    cb.append("text");
                    continue;
                }
                if (name.getNamespaceURI() == null || qName == null) {
                    cb.append(new StringBuffer().append("<").append(name.getName()).append(">").toString());
                    continue;
                }
                if (qName.getNamespaceURI() != name.getNamespaceURI()) {
                    if (name.getPrefix() != null) {
                        cb.append(new StringBuffer().append("<").append(name.getName()).append(" xmlns:").append(name.getPrefix()).append("=\"").append(name.getNamespaceURI()).append("\">").toString());
                        continue;
                    }
                    cb.append(new StringBuffer().append("<").append(name.getName()).append(" xmlns=\"").append(name.getNamespaceURI()).append("\">").toString());
                    continue;
                }
                cb.append(new StringBuffer().append("<").append(name.getName()).append(">").toString());
            }
            if (values.size() == 1) {
                cb.append(" is expected");
            } else {
                cb.append(" are expected");
            }
            if (allowEmpty) {
                if (parentName == null || parentName.equals("#top")) {
                    cb.append(",\nor the document may end.");
                } else {
                    cb.append(new StringBuffer().append(",\nor </").append(parentName).append("> may close.").toString());
                }
            } else {
                cb.append(".");
            }
        } else if (allowEmpty) {
            if (parentName == null || parentName.equals("#top")) {
                cb.append("\n\nThe document is expected to end.");
            } else {
                cb.append(new StringBuffer().append("\n\n</").append(parentName).append("> is expected to close.").toString());
            }
        }
        return cb.toString();
    }

    private String allowedAttributes(Item item, QName qName) {
        if (item == null) {
            return "";
        }
        HashSet<QName> values = new HashSet<QName>();
        item.attributeSet(values);
        CharBuffer cb = new CharBuffer();
        if (values.size() > 0) {
            ArrayList<QName> sortedValues = new ArrayList<QName>(values);
            Collections.sort(sortedValues);
            for (int i = 0; i < sortedValues.size(); ++i) {
                QName name = sortedValues.get(i);
                if (i == 0) {
                    cb.append("\n\n");
                } else if (i == sortedValues.size() - 1) {
                    cb.append(" or ");
                } else {
                    cb.append(", ");
                }
                String uri = name.getNamespaceURI();
                if (uri == null || uri.equals("")) {
                    cb.append(new StringBuffer().append("'").append(name.getName()).append("'").toString());
                    continue;
                }
                if (qName == null || qName.getName().equals(name.getName())) {
                    cb.append(new StringBuffer().append("'").append(name.getCanonicalName()).append("'").toString());
                    continue;
                }
                cb.append(new StringBuffer().append("'").append(name.getName()).append("'").toString());
            }
            if (values.size() == 1) {
                cb.append(" is expected.");
            } else {
                cb.append(" are expected.");
            }
        }
        return cb.toString();
    }

    private String getLocation() {
        if (this._locator == null) {
            return "";
        }
        return new StringBuffer().append("").append(this._locator.getLineNumber()).toString();
    }

    @Override
    public boolean isValid() throws IllegalStateException {
        return this._isValid;
    }

    static class EndElementKey {
        private Item _item;

        public EndElementKey(Item item) {
            this._item = item;
        }

        public EndElementKey() {
        }

        public void init(Item item) {
            this._item = item;
        }

        public int hashCode() {
            return 137 + this._item.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != ClassLiteral.getClass((String)"com/caucho/relaxng/VerifierHandlerImpl$EndElementKey")) {
                return false;
            }
            EndElementKey key = (EndElementKey)o;
            return this._item.equals(key._item);
        }
    }

    static class StartKey {
        private Item _item;
        private QName _name;

        public StartKey(Item item, QName name) {
            this._item = item;
            this._name = name;
        }

        public StartKey() {
        }

        public void init(Item item, QName name) {
            this._item = item;
            this._name = name;
        }

        public int hashCode() {
            return this._name.hashCode() + 137 * this._item.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != ClassLiteral.getClass((String)"com/caucho/relaxng/VerifierHandlerImpl$StartKey")) {
                return false;
            }
            StartKey key = (StartKey)o;
            return this._name.equals(key._name) && this._item.equals(key._item);
        }
    }
}

