/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources.rmi;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.resources.rmi.RmiRegistry;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ResourceAdapterInternalException;

public class RmiService {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/resources/rmi/RmiService"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/resources/rmi/RmiService"));
    private RmiRegistry _registry;
    private String _serviceName;
    private String _serviceClass;
    private Class _serviceClassClass;
    private String _boundName;
    private Remote _boundObject;

    public void setServiceName(String name) {
        this._serviceName = name;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public void setServiceClass(String serviceClass) {
        this._serviceClass = serviceClass;
    }

    public String getServiceClass() {
        return this._serviceClass;
    }

    public void setParent(Object parent) {
        if (parent instanceof RmiRegistry) {
            this._registry = (RmiRegistry)parent;
        }
    }

    public void init() throws ConfigException {
        if (this._registry == null) {
            throw new ConfigException(L.l("{0} must be used as a child of {1}", (Object)"RmiService", "RmiRegistry"));
        }
        if (this._serviceClass == null) {
            throw new ConfigException(L.l("`{0}' is required", "service-class"));
        }
        if (this._serviceName == null) {
            throw new ConfigException(L.l("`{0}' is required", "service-name"));
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this._serviceClassClass = loader != null ? Class.forName(this._serviceClass, false, loader) : Class.forName(this._serviceClass);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigException(L.l("no class found with name `{0}'", this._serviceClass));
        }
    }

    public void start() throws ResourceAdapterInternalException {
        String fullName = this._registry.makeFullName(this._serviceName);
        if (this._boundName != null) {
            throw new ResourceAdapterInternalException(L.l("cannot bind rmi service with name `{0}', already bound with name `{1}'", (Object)fullName, this._boundName));
        }
        try {
            this._boundObject = (Remote)this._serviceClassClass.newInstance();
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("binding rmi name `{0}' to object `{1}'", (Object)fullName, this._boundObject.getClass().getName()));
            }
            Naming.rebind(fullName, this._boundObject);
            this._boundName = fullName;
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException(L.l("error binding rmi service with name `{0}'", fullName), ex);
        }
    }

    void stop() {
        if (this._boundName != null) {
            block8: {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(L.l("unbinding rmi name `{0}'", this._boundName));
                    }
                    Naming.unbind(this._boundName);
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block8;
                    log.log(Level.INFO, L.l("error unbinding rmi name `{0}'", this._boundName), ex);
                }
            }
            this._boundName = null;
        }
        if (this._boundObject != null) {
            block9: {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(L.l("unexporting rmi object `{0}'", this._boundObject.getClass().getName()));
                    }
                    UnicastRemoteObject.unexportObject(this._boundObject, true);
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.FINE)) break block9;
                    log.log(Level.FINE, L.l("error unexporting rmi object `{0}'", this._boundObject.getClass().getName()), ex);
                }
            }
            this._boundObject = null;
        }
    }
}

