/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.util.Alarm;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;

public class ClusterClient {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterClient"));
    private ClusterServer _server;
    private int _timeout = 2000;
    private int _maxPoolSize = 16;
    private ClusterStream[] _free = new ClusterStream[64];
    private int _freeHead;
    private int _freeTail;
    private int _freeSize = 16;
    private long _lastFailTime;
    private int _activeCount;
    private boolean _isClosed;

    public ClusterClient(ClusterServer server) {
        this._server = server;
        this._timeout = (int)server.getReadTimeout();
    }

    public ClusterServer getServer() {
        return this._server;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = (int)timeout;
    }

    public int getActiveCount() {
        return this._activeCount;
    }

    public void setMaxPoolSize(int size) {
        this._maxPoolSize = size;
    }

    public boolean isDead() {
        long now = Alarm.getCurrentTime();
        return now < this._lastFailTime + this._server.getDeadTime() || this._isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStream openRecycle() {
        if (this._isClosed) {
            return null;
        }
        long now = Alarm.getCurrentTime();
        ClusterStream stream = null;
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            if (this._freeHead != this._freeTail) {
                stream = this._free[this._freeTail];
                long freeTime = stream.getFreeTime();
                this._free[this._freeTail] = null;
                this._freeTail = (this._freeTail + 1) % this._free.length;
                if (now < freeTime + this._server.getLiveTime()) {
                    ++this._activeCount;
                    return stream;
                }
            }
        }
        if (stream != null) {
            stream.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStream open() {
        long now = Alarm.getCurrentTime();
        if (now < this._lastFailTime + this._server.getDeadTime() || this._isClosed) {
            return null;
        }
        ClusterStream recycleStream = this.openRecycle();
        if (recycleStream != null) {
            return recycleStream;
        }
        try {
            ReadWritePair pair = this._server.openTCPPair();
            ReadStream rs = pair.getReadStream();
            rs.setAttribute("timeout", new Integer((int)this._server.getReadTimeout()));
            ClusterClient clusterClient = this;
            synchronized (clusterClient) {
                ++this._activeCount;
            }
            return new ClusterStream(this, rs, pair.getWriteStream());
        }
        catch (IOException e) {
            this._lastFailTime = now;
            return null;
        }
    }

    public void wake() {
        this._lastFailTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(ClusterStream stream) {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            --this._activeCount;
            int size = (this._freeHead - this._freeTail + this._free.length) % this._free.length;
            if (!this._isClosed && size < this._freeSize) {
                this._free[this._freeHead] = stream;
                this._freeHead = (this._freeHead + 1) % this._free.length;
                return;
            }
        }
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClusterStream stream) {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            --this._activeCount;
        }
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ClusterClient clusterClient = this;
        synchronized (clusterClient) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            this._freeTail = 0;
            this._freeHead = 0;
        }
        for (int i = 0; i < this._free.length; ++i) {
            ClusterStream stream;
            ClusterClient clusterClient2 = this;
            synchronized (clusterClient2) {
                stream = this._free[i];
                this._free[i] = null;
            }
            if (stream == null) continue;
            stream.close();
        }
    }

    public String toString() {
        return "ClusterClient[" + this._server + "]";
    }
}

