/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterClient;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.Store;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.TempStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StoreManager
implements AlarmListener,
EnvironmentListener,
ClassLoaderListener {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/StoreManager"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/StoreManager"));
    static final long ACCESS_WINDOW = 600000L;
    private Cluster _cluster;
    private String _serverId;
    protected ClusterServer _selfServer;
    private int _selfServerIndex;
    private Alarm _alarm;
    protected long _maxIdleTime = 86400000L;
    protected boolean _isAlwaysLoad;
    protected boolean _isAlwaysSave;
    protected HashMap<String, Store> _storeMap;
    protected LruCache<ObjectKey, ClusterObject> _clusterObjects = new LruCache(4096);
    private final ObjectKey _objectKey = new ObjectKey();
    private volatile boolean _isStarted;
    private volatile boolean _isActive;
    private volatile boolean _isClosed;

    protected abstract boolean load(ClusterObject var1, Object var2) throws Exception;

    protected abstract void store(ClusterObject var1, TempStream var2, long var3, int var5) throws Exception;

    protected StoreManager() {
        this._storeMap = new HashMap();
        this._alarm = new Alarm(this);
        Environment.addClassLoaderListener(this);
    }

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public void setAlwaysLoad(boolean alwaysLoad) {
        this._isAlwaysLoad = alwaysLoad;
    }

    public boolean isAlwaysLoad() {
        return this._isAlwaysLoad;
    }

    public void setAlwaysSave(boolean alwaysSave) {
        this._isAlwaysSave = alwaysSave;
    }

    public boolean isAlwaysSave() {
        return this._isAlwaysSave;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(Period maxIdleTime) {
        this._maxIdleTime = maxIdleTime.getPeriod();
    }

    public Store createStore(String storeId, ObjectManager objectManager) {
        Store store = this.getStore(storeId);
        store.setObjectManager(objectManager);
        return store;
    }

    public Store removeStore(String storeId) {
        Store store = this.getStore(storeId);
        store.setObjectManager(null);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store getStore(String storeId) {
        HashMap<String, Store> hashMap = this._storeMap;
        synchronized (hashMap) {
            Store store = this._storeMap.get(storeId);
            if (store == null) {
                store = new Store(storeId, this);
                this._storeMap.put(storeId, store);
            }
            return store;
        }
    }

    public void init() throws Exception {
        if (this._cluster == null) {
            this._cluster = Cluster.getLocal();
        }
        if (this._cluster != null) {
            StoreManager storeManager = this;
            this._serverId = storeManager._cluster.getServerId();
            this._selfServer = this._cluster.getSelfServer();
            if (this._selfServer != null) {
                this._selfServerIndex = this._selfServer.getIndex();
            } else if (this._cluster.getServerList().length > 1) {
                throw new ConfigException(L.l("cluster-store for '{0}' needs an <srun> configuration for it.", this._serverId));
            }
        }
        Environment.addEnvironmentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        StoreManager storeManager = this;
        synchronized (storeManager) {
            if (this._isStarted) {
                return;
            }
            this._isStarted = true;
        }
        this._isActive = true;
        if (this._cluster != null) {
            ClusterServer[] serverList = this._cluster.getServerList();
            for (int i = 0; i < serverList.length; ++i) {
                ClusterServer server = serverList[i];
                if (server == null || server == this._selfServer) continue;
                ClusterClient client = server.getClient();
                try {
                    if (client == null) continue;
                    ClusterStream s = client.open();
                    s.close();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        this.handleAlarm(this._alarm);
    }

    public int getOwnerIndex(String id) {
        return 0;
    }

    public int getBackupIndex(String id) {
        return 0;
    }

    public void clearOldObjects() throws Exception {
    }

    public void access(Store store, String id) throws Exception {
        this.getClusterObject(store, id).access();
    }

    public void accessImpl(String storeId, String id) throws Exception {
    }

    public void update(String storeId, String objectId) throws Exception {
        ClusterObject obj = this.getClusterObject(storeId, objectId);
        if (obj != null) {
            obj.update();
        }
    }

    public void updateOwner(String objectId, String uniqueId) throws Exception {
    }

    public void store(Store store, String id, Object obj) throws IOException {
        ClusterObject clusterObj = this.getClusterObject(store, id);
        if (clusterObj == null) {
            if (store.getObjectManager().isEmpty(obj)) {
                return;
            }
            clusterObj = this.createClusterObject(store, id);
        }
        clusterObj.store(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject createClusterObject(Store store, String id) {
        try {
            StoreManager storeManager = this;
            synchronized (storeManager) {
                this._objectKey.init(store.getId(), id);
                ClusterObject clusterObj = this._clusterObjects.get(this._objectKey);
                if (clusterObj == null) {
                    clusterObj = this.create(store, id);
                    this._clusterObjects.put(new ObjectKey(store.getId(), id), clusterObj);
                }
                return clusterObj;
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject getClusterObject(Store store, String id) {
        try {
            StoreManager storeManager = this;
            synchronized (storeManager) {
                this._objectKey.init(store.getId(), id);
                return this._clusterObjects.get(this._objectKey);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject getClusterObject(String storeId, String id) {
        StoreManager storeManager = this;
        synchronized (storeManager) {
            this._objectKey.init(storeId, id);
            return this._clusterObjects.get(this._objectKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterObject removeClusterObject(String storeId, String id) {
        StoreManager storeManager = this;
        synchronized (storeManager) {
            this._objectKey.init(storeId, id);
            return this._clusterObjects.remove(this._objectKey);
        }
    }

    ClusterObject create(Store store, String id) {
        return new ClusterObject(this, store, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this._isClosed) {
            return;
        }
        try {
            this.clearOldObjects();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._alarm.queue(this._maxIdleTime);
        }
    }

    public void remove(ClusterObject obj) throws Exception {
    }

    public void remove(Store store, String objectId) throws Exception {
    }

    protected ClusterServer getOwningServer(String objectId) {
        if (this._cluster == null) {
            return null;
        }
        char ch = objectId.charAt(0);
        if (ch < 'a' || ch > 'z') {
            return null;
        }
        int srunIndex = ch - 97;
        return this._cluster.getServerList()[srunIndex];
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    public void destroy() {
        this._isClosed = true;
        this._isActive = true;
        this._alarm.dequeue();
    }

    static class ObjectKey {
        private String _storeId;
        private String _objectId;

        ObjectKey() {
        }

        ObjectKey(String storeId, String objectId) {
            this.init(storeId, objectId);
        }

        void init(String storeId, String objectId) {
            this._storeId = storeId;
            this._objectId = objectId;
        }

        public int hashCode() {
            return this._storeId.hashCode() * 65521 + this._objectId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ObjectKey)) {
                return false;
            }
            ObjectKey key = (ObjectKey)o;
            return this._objectId.equals(key._objectId) && this._storeId.equals(key._storeId);
        }
    }
}

