/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.ToByteResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

public class IncludeResponseStream
extends ToByteResponseStream {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/connection/IncludeResponseStream"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/connection/IncludeResponseStream"));
    private final AbstractHttpResponse _response;
    private boolean _isCauchoResponseStream;
    private ServletResponse _next;
    private ServletOutputStream _os;
    private PrintWriter _writer;
    private WriteStream _cacheStream;

    public IncludeResponseStream(AbstractHttpResponse response) {
        this._response = response;
    }

    public void init(ServletResponse next) {
        this._next = next;
        if (this._os != null || this._writer != null) {
            throw new IllegalStateException();
        }
        if (this._next instanceof AbstractHttpResponse) {
            AbstractHttpResponse response = (AbstractHttpResponse)next;
            this._isCauchoResponseStream = response.isCauchoResponseStream();
        } else {
            this._isCauchoResponseStream = false;
        }
    }

    public void start() {
        super.start();
        try {
            this.setEncoding(this._next.getCharacterEncoding());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean isCauchoResponseStream() {
        return this._isCauchoResponseStream;
    }

    public void setCache(WriteStream cacheStream) {
        this._cacheStream = cacheStream;
    }

    protected void flushCharBuffer() throws IOException {
        if (this._isCauchoResponseStream) {
            super.flushCharBuffer();
            return;
        }
        try {
            if (this._writer == null) {
                this._writer = this._next.getWriter();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (this._writer != null) {
            int charLength = this.getCharOffset();
            this.setCharOffset(0);
            char[] buffer = this.getCharBuffer();
            this._writer.write(buffer, 0, charLength);
        } else {
            super.flushCharBuffer();
        }
    }

    public void setBufferOffset(int offset) throws IOException {
        super.setBufferOffset(offset);
        if (!this._isCauchoResponseStream) {
            this.flushByteBuffer();
        }
    }

    public void write(int ch) throws IOException {
        if (this._isCauchoResponseStream) {
            super.write(ch);
        } else {
            this.flushCharBuffer();
            if (this._os == null) {
                this._os = this._next.getOutputStream();
            }
            this._os.write(ch);
        }
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        if (this._isCauchoResponseStream) {
            super.write(buf, offset, length);
        } else {
            this.flushCharBuffer();
            if (this._os == null) {
                this._os = this._next.getOutputStream();
            }
            this._os.write(buf, offset, length);
        }
    }

    protected void writeNext(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        try {
            if (this._response != null) {
                this._response.writeHeaders(null, -1);
            }
            if (length == 0) {
                return;
            }
            if (this._cacheStream != null) {
                this._cacheStream.write(buf, offset, length);
            }
            if (this._os == null) {
                this._os = this._next.getOutputStream();
            }
            this._os.write(buf, offset, length);
        }
        catch (IOException e) {
            if (this._next instanceof CauchoResponse) {
                ((CauchoResponse)this._next).killCache();
            }
            if (this._response != null) {
                this._response.killCache();
            }
            throw e;
        }
    }

    public void flushByte() throws IOException {
        this.flushBuffer();
        if (this._os == null) {
            this._os = this._next.getOutputStream();
        }
        this._os.flush();
    }

    public void flushChar() throws IOException {
        this.flushBuffer();
        if (this._writer == null) {
            this._writer = this._next.getWriter();
        }
        this._writer.flush();
    }

    public void finish() throws IOException {
        this.flushBuffer();
        this._os = null;
        this._writer = null;
        this._next = null;
        this._cacheStream = null;
    }

    public void close() throws IOException {
        super.close();
        this._os = null;
        this._writer = null;
        this._next = null;
        this._cacheStream = null;
    }
}

