/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.RequestAdapter;
import com.caucho.server.connection.ResponseWrapper;
import com.caucho.server.connection.ResponseWriter;
import com.caucho.server.connection.ServletOutputStreamImpl;
import com.caucho.server.connection.WrapperResponseStream;
import com.caucho.util.FreeList;
import com.caucho.vfs.FlushBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ResponseAdapter
extends ResponseWrapper
implements CauchoResponse {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/connection/ResponseAdapter"));
    private static final FreeList<ResponseAdapter> _freeList = new FreeList(32);
    protected RequestAdapter _request;
    protected FlushBuffer _flushBuffer;
    protected WrapperResponseStream _originalResponseStream;
    protected AbstractResponseStream _responseStream;
    private ServletOutputStreamImpl _os;
    private ResponseWriter _writer;
    private boolean _hasOutputStream;
    private boolean _hasError;

    private ResponseAdapter() {
    }

    private ResponseAdapter(HttpServletResponse response) {
        this.setResponse(response);
        this._originalResponseStream = new WrapperResponseStream();
        this._os = new ServletOutputStreamImpl();
        this._writer = new ResponseWriter();
    }

    public static ResponseAdapter create(HttpServletResponse response) {
        ResponseAdapter resAdapt = _freeList.allocate();
        if (resAdapt == null) {
            resAdapt = new ResponseAdapter(response);
        } else {
            resAdapt.setResponse(response);
        }
        resAdapt.init(response);
        return resAdapt;
    }

    void setRequest(RequestAdapter request) {
        this._request = request;
    }

    public void init(HttpServletResponse response) {
        this.setResponse(response);
        this._hasError = false;
        this._responseStream = this._originalResponseStream;
        this._originalResponseStream.init(response);
        this._originalResponseStream.start();
        this._os.init(this._originalResponseStream);
        this._writer.init(this._originalResponseStream);
    }

    public AbstractResponseStream getResponseStream() {
        return this._responseStream;
    }

    public void setResponseStream(AbstractResponseStream responseStream) {
        this._responseStream = responseStream;
        this._os.init(responseStream);
        this._writer.init(responseStream);
    }

    public boolean isTop() {
        return false;
    }

    public void resetBuffer() {
        super.resetBuffer();
        this._responseStream.clearBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    public void setContentType(String value) {
        super.setContentType(value);
        try {
            this._responseStream.setEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void addCookie(Cookie cookie) {
        if (this._request != null) {
            this._request.setHasCookie();
        }
        super.addCookie(cookie);
    }

    public String getHeader(String key) {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public int getRemaining() {
        return this._responseStream.getRemaining();
    }

    public void setForbidForward(boolean forbid) {
    }

    public boolean getForbidForward() {
        return false;
    }

    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public void killCache() {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).killCache();
        }
    }

    public void setPrivateCache(boolean isPrivate) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setPrivateCache(isPrivate);
        }
    }

    public void setNoCache(boolean isPrivate) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setNoCache(isPrivate);
        }
    }

    public void setSessionId(String id) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setSessionId(id);
        }
    }

    public void finish() throws IOException {
        if (this._responseStream != null) {
            this._responseStream.flushBuffer();
        }
        this._responseStream = this._originalResponseStream;
    }

    public void close() throws IOException {
        ServletResponse response = this.getResponse();
        AbstractResponseStream responseStream = this._responseStream;
        this._responseStream = this._originalResponseStream;
        if (responseStream != null) {
            responseStream.close();
        }
        if (this._originalResponseStream != responseStream) {
            this._originalResponseStream.close();
        }
        this._responseStream = this._originalResponseStream;
        if (response instanceof CauchoResponse) {
            ((CauchoResponse)response).close();
        }
    }

    public static void free(ResponseAdapter resAdapt) {
        resAdapt.free();
        _freeList.free(resAdapt);
    }

    protected void free() {
        this._request = null;
        this._responseStream = null;
        this.setResponse(null);
    }
}

