/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.Entry;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Deploy<E extends Entry>
implements Dependency,
EnvironmentListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/deploy/Deploy"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/deploy/Deploy"));
    private DeployContainer<E> _container;
    private ClassLoader _parentClassLoader;
    private String _startupMode = "automatic";

    public Deploy(DeployContainer<E> container) {
        this._container = container;
        this._parentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public DeployContainer<E> getDeployContainer() {
        return this._container;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentClassLoader;
    }

    public void setStartupMode(String mode) throws ConfigException {
        this._startupMode = Entry.toStartupCode(mode);
    }

    public String getStartupMode() throws ConfigException {
        return this._startupMode;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void start() {
        Environment.addEnvironmentListener(this);
    }

    public void update() {
        this.redeployIfModified();
    }

    public void redeployIfModified() {
    }

    protected void fillDeployedKeys(Set<String> keys) {
    }

    protected E generateEntry(String key) {
        return null;
    }

    protected E mergeEntry(E entry, String key) {
        return entry;
    }

    protected Logger getLog() {
        return log;
    }

    public void stop() {
    }

    public void destroy() {
        this._container.remove(this);
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
        this.redeployIfModified();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }
}

