/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entry<I extends DeployInstance>
implements Dependency,
AlarmListener {
    private static final Logger log;
    private static final L10N L;
    public static final String STARTUP_DEFAULT = "default";
    public static final String STARTUP_AUTOMATIC = "automatic";
    public static final String STARTUP_LAZY = "lazy";
    public static final String STARTUP_MANUAL = "manual";
    public static final String REDEPLOY_DEFAULT = "default";
    public static final String REDEPLOY_AUTOMATIC = "automatic";
    public static final String REDEPLOY_LAZY = "lazy";
    public static final String REDEPLOY_MANUAL = "manual";
    private DeployContainer _deployContainer;
    private ClassLoader _parentLoader;
    private String _name;
    private String _startupMode = "automatic";
    private String _redeployMode = "automatic";
    protected final Lifecycle _lifecycle = new Lifecycle(this.getLog());
    private Alarm _alarm = new WeakAlarm(this);
    private long _redeployCheckInterval = 60000L;
    private long _startTime;
    private I _deployInstance;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract I instantiateDeployInstance();

    protected Entry() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected Entry(ClassLoader parentLoader) {
        this._parentLoader = parentLoader;
    }

    public void setDeployContainer(DeployContainer deploy) {
        this._deployContainer = deploy;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setStartupMode(String mode) {
        try {
            this._startupMode = Entry.toStartupCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeStartupMode(String mode) {
        if ("default".equals(mode)) {
            return;
        }
        this._startupMode = mode;
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public static String toStartupCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown startup-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", mode));
    }

    public boolean isStartupAutomatic() {
        return this._startupMode == "automatic" || this._startupMode == "default";
    }

    public boolean isStartupLazy() {
        return this._startupMode == "lazy";
    }

    public boolean isStartupManual() {
        return this._startupMode == "manual";
    }

    public void setRedeployMode(String mode) {
        try {
            this._redeployMode = Entry.toRedeployCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeRedeployMode(String mode) {
        if ("default".equals(mode)) {
            return;
        }
        this._redeployMode = mode;
    }

    public String getRedeployMode() {
        return this._redeployMode;
    }

    public static String toRedeployCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown redeploy-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", mode));
    }

    public boolean isRedeployAutomatic() {
        return this._redeployMode == "automatic" || this._redeployMode == "default";
    }

    public boolean isRedeployLazy() {
        return this._redeployMode == "lazy";
    }

    public boolean isRedeployManual() {
        return this._redeployMode == "manual" || this._startupMode == "manual";
    }

    public boolean isNameMatch(String name) {
        return name.equals(this._name);
    }

    public long getStartTime() {
        return this._startTime;
    }

    public boolean init() {
        this._lifecycle.setName(this.toString());
        if (this._parentLoader != Thread.currentThread().getContextClassLoader()) {
            Thread.dumpStack();
        }
        if (!$assertionsDisabled && this._parentLoader != Thread.currentThread().getContextClassLoader()) {
            throw new AssertionError();
        }
        return this._lifecycle.toInit();
    }

    @Override
    public boolean isModified() {
        I instance = this._deployInstance;
        return instance == null || instance.isModified();
    }

    public I getDeployInstance() {
        return this._deployInstance;
    }

    public I createLazyInstance() {
        return this.createLazyInstance(false);
    }

    public I createLazyInstance(boolean enableRedeploy) {
        if (!$assertionsDisabled && !this._lifecycle.isAfterInit()) {
            throw new AssertionError();
        }
        return this.redeployIfModifiedImpl(true, enableRedeploy);
    }

    public I createLazyRedeployInstance() {
        if (!$assertionsDisabled && !this._lifecycle.isAfterInit()) {
            throw new AssertionError();
        }
        return this.redeployIfModifiedImpl(true, true);
    }

    public void startAutomatic() {
        if (!$assertionsDisabled && !this._lifecycle.isAfterInit()) {
            throw new AssertionError();
        }
        if (this._startupMode != "manual") {
            this._alarm.queue(this._redeployCheckInterval);
        }
        if (this._startupMode != "automatic") {
            return;
        }
        this.redeployIfModifiedImpl(false, false);
    }

    public final void redeployIfModified() {
        this.redeployIfModifiedImpl(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I redeployIfModifiedImpl(boolean lazyRequest, boolean enableRedeploy) {
        I oldInstance = this._deployInstance;
        if (this._startupMode == "manual") {
            return oldInstance;
        }
        if (oldInstance == null) {
            if (!lazyRequest && this._startupMode != "automatic") {
                return null;
            }
        } else {
            if (this._redeployMode == "manual" || !enableRedeploy) {
                return oldInstance;
            }
            if (lazyRequest && !oldInstance.isModified() || !lazyRequest && !oldInstance.isModifiedForAutomaticRedeploy()) {
                return oldInstance;
            }
            if (!this._lifecycle.toStopping()) {
                return oldInstance;
            }
        }
        if (oldInstance != null) {
            try {
                oldInstance.destroy();
            }
            finally {
                this._lifecycle.toStop();
            }
        }
        return this.startImpl();
    }

    public final void start() {
        this.startImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I startImpl() {
        if (!$assertionsDisabled && !this._lifecycle.isAfterInit()) {
            throw new AssertionError();
        }
        if (DynamicClassLoader.isModified(this._parentLoader)) {
            this._deployInstance = null;
            return null;
        }
        if (!this._lifecycle.toStarting()) {
            return this._deployInstance;
        }
        DeployInstance deployInstance = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            deployInstance = this.instantiateDeployInstance();
            this._deployInstance = deployInstance;
            this.deploy();
            this.configureInstance(deployInstance);
            deployInstance.start();
            this._startTime = Alarm.getCurrentTime();
        }
        catch (Throwable e) {
            deployInstance.setConfigException(e);
            log.log(Level.WARNING, e.toString(), e.toString());
        }
        finally {
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
        }
        return (I)deployInstance;
    }

    protected void deploy() throws IOException {
    }

    protected void configureInstance(I deployInstance) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stop() {
        I oldInstance;
        if (!this._lifecycle.toStopping()) {
            return;
        }
        Entry entry = this;
        synchronized (entry) {
            oldInstance = this._deployInstance;
            this._deployInstance = null;
        }
        try {
            if (oldInstance != null) {
                oldInstance.destroy();
            }
        }
        finally {
            this._lifecycle.toStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            this.redeployIfModifiedImpl(false, true);
        }
        finally {
            if (!this._lifecycle.isDestroyed()) {
                alarm.queue(this._redeployCheckInterval);
            }
        }
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    protected boolean destroy() {
        this.stop();
        if (this._alarm != null) {
            this._alarm.dequeue();
            this._alarm = null;
        }
        return this._lifecycle.toDestroy();
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return new StringBuffer().append(className.substring(p + 1)).append("[").append(this._name).append("]").toString();
    }

    static {
        $assertionsDisabled = !ClassLiteral.getClass((String)"com/caucho/server/deploy/Entry").desiredAssertionStatus();
        log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/deploy/Entry"));
        L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/deploy/Entry"));
    }
}

