/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.Entry;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeploy<E extends Entry>
extends Deploy<E>
implements AlarmListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/deploy/ExpandDeploy"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/deploy/ExpandDeploy"));
    private Path _path;
    private Path _archiveDirectory;
    private Path _expandDirectory;
    private String _extension = ".jar";
    private TreeSet<String> _entryNames = new TreeSet();
    private ArrayList<E> _entries = new ArrayList();
    private Alarm _alarm;
    private long _cronInterval = 60000L;
    private volatile long _lastCheckTime;
    private volatile boolean _isChecking;
    private long _checkInterval = 1000L;
    private volatile boolean _isModified;
    private volatile boolean _isDeploying;
    private final Lifecycle _lifecycle = new Lifecycle();

    protected abstract E createEntry(String var1) throws Exception;

    public ExpandDeploy(DeployContainer container) {
        super(container);
        this._alarm = new WeakAlarm(this);
    }

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setExpandPath(Path path) {
        log.config("Use <expand-directory> instead of <expand-path>.  <expand-path> is deprecated.");
        this.setExpandDirectory(path);
    }

    public void setExpandDirectory(Path path) {
        this._expandDirectory = path;
    }

    public Path getExpandDirectory() {
        if (this._expandDirectory != null) {
            return this._expandDirectory;
        }
        return this._path;
    }

    public void setArchiveDirectory(Path path) {
        this._archiveDirectory = path;
    }

    public Path getArchiveDirectory() {
        if (this._archiveDirectory != null) {
            return this._archiveDirectory;
        }
        return this._path;
    }

    public void setExtension(String extension) throws ConfigException {
        if (!extension.startsWith(".")) {
            throw new ConfigException(L.l("deployment extension '{0}' must begin with '.'", extension));
        }
        this._extension = extension;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        Object object = this;
        synchronized (object) {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval || this._isChecking) {
                return this._isModified;
            }
            this._isChecking = true;
            this._lastCheckTime = Alarm.getCurrentTime();
        }
        try {
            object = this._entryNames;
            synchronized (object) {
                try {
                    boolean bl = this._isModified = !this._entryNames.equals(this.findEntryNames());
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            this._isChecking = false;
        }
    }

    public ArrayList<E> getEntries() {
        return this._entries;
    }

    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        if (this.getExpandDirectory() == null) {
            throw new ConfigException(L.l("<expand-directory> must be specified for deployment of archive expansion."));
        }
        if (this.getArchiveDirectory() == null) {
            throw new ConfigException(L.l("<archive-directory> must be specified for deployment of archive expansion."));
        }
    }

    @Override
    public void start() {
        try {
            this.init();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(new StringBuffer().append(this).append(" starting").toString());
        this.handleAlarm(this._alarm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        ArrayList newEntries = null;
        ArrayList oldEntries = null;
        ArrayList<E> entries = null;
        boolean isDeploying = false;
        log.finer(new StringBuffer().append(this).append(" redeploy ").append(this._isDeploying).toString());
        try {
            Entry entry;
            int i;
            ExpandDeploy expandDeploy = this;
            synchronized (expandDeploy) {
                block12: {
                    if (!this._isDeploying) break block12;
                    return;
                }
                this._isDeploying = true;
                isDeploying = true;
                TreeSet<String> entryNames = this.findEntryNames();
                if (!this._entryNames.equals(entryNames)) {
                    this._entryNames = entryNames;
                    oldEntries = new ArrayList();
                    newEntries = new ArrayList();
                    this.updateEntries(entryNames, oldEntries, newEntries);
                }
                entries = new ArrayList<E>();
                entries.addAll(this._entries);
            }
            for (i = 0; oldEntries != null && i < oldEntries.size(); ++i) {
                entry = (Entry)oldEntries.get(i);
                this.getDeployContainer().update(entry.getName());
            }
            for (i = 0; newEntries != null && i < newEntries.size(); ++i) {
                entry = (Entry)newEntries.get(i);
                this.getDeployContainer().update(entry.getName());
            }
        }
        finally {
            if (isDeploying) {
                this._isModified = false;
                this._isDeploying = false;
            }
        }
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (String name : this._entryNames) {
            keys.add(name);
        }
    }

    @Override
    public void update() {
        this._lastCheckTime = 0L;
        this.redeployIfModified();
    }

    @Override
    public void redeployIfModified() {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (int i = 0; i < this._entries.size(); ++i) {
            Entry entry = (Entry)this._entries.get(i);
            entry.redeployIfModified();
        }
    }

    @Override
    public E generateEntry(String name) {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (int i = 0; i < this._entries.size(); ++i) {
            Entry entry = (Entry)this._entries.get(i);
            if (!entry.isNameMatch(name)) continue;
            return (E)entry;
        }
        return null;
    }

    private TreeSet<String> findEntryNames() throws IOException {
        TreeSet<String> entryNames = new TreeSet<String>();
        Path archiveDirectory = this.getArchiveDirectory();
        Path expandDirectory = this.getExpandDirectory();
        if (archiveDirectory == null || expandDirectory == null) {
            return entryNames;
        }
        String[] entryList = archiveDirectory.list();
        for (int i = 0; i < entryList.length; ++i) {
            String entryName;
            String archiveName = entryList[i];
            Path archivePath = archiveDirectory.lookup(archiveName);
            if (!archivePath.canRead() || (entryName = this.archiveNameToEntryName(archiveName)) == null) continue;
            entryNames.add(entryName);
        }
        String[] entryExpandList = expandDirectory.list();
        for (int i = 0; i < entryExpandList.length; ++i) {
            String pathName = entryExpandList[i];
            Path rootDirectory = expandDirectory.lookup(pathName);
            String entryName = this.pathNameToEntryName(pathName);
            if (entryName == null || !rootDirectory.isDirectory() || pathName.startsWith(".") || pathName.equalsIgnoreCase("web-inf") || pathName.equalsIgnoreCase("meta-inf") || entryNames.contains(entryName)) continue;
            entryNames.add(entryName);
        }
        return entryNames;
    }

    protected String pathNameToEntryName(String name) {
        return name;
    }

    protected String archiveNameToEntryName(String archiveName) {
        if (!archiveName.endsWith(this._extension)) {
            return null;
        }
        int sublen = archiveName.length() - this._extension.length();
        return this.pathNameToEntryName(archiveName.substring(0, sublen));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(TreeSet<String> entryNames, ArrayList<E> oldEntries, ArrayList<E> newEntries) throws Exception {
        ArrayList entries = new ArrayList();
        for (int i = this._entries.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)this._entries.get(i);
            if (entryNames.contains(entry.getName())) continue;
            oldEntries.add(entry);
            this._entries.remove(i);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        for (String name : entryNames) {
            E entry = this.getEntry(this._entries, name);
            if (entry != null) continue;
            try {
                thread.setContextClassLoader(this.getParentClassLoader());
                entry = this.createEntry(name);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            newEntries.add(entry);
            this._entries.add(entry);
        }
    }

    private E getEntry(ArrayList<E> entries, String name) {
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = (Entry)entries.get(i);
            if (!entry.isNameMatch(name)) continue;
            return (E)entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            if (this.isModified()) {
                this.deploy();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._alarm.queue(this._cronInterval);
        }
    }

    @Override
    public void stop() {
        this._lifecycle.toStop();
        this._alarm.dequeue();
    }

    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<E> entries = new ArrayList<E>(this._entries);
        this._entries = null;
        for (int i = 0; i < entries.size(); ++i) {
            try {
                ((Entry)entries.get(i)).destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this._lifecycle.toDestroy();
    }

    public boolean equals(Object o) {
        Path deployExpandDirectory;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ExpandDeploy deploy = (ExpandDeploy)o;
        Path expandDirectory = this.getExpandDirectory();
        return expandDirectory == (deployExpandDirectory = deploy.getExpandDirectory()) || expandDirectory != null && expandDirectory.equals(deployExpandDirectory);
    }

    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return new StringBuffer().append(name).append("[").append(this.getExpandDirectory()).append("]").toString();
    }
}

