/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.types.InitProgram;
import com.caucho.log.Log;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;

public class FilterManager {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/dispatch/FilterManager"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/dispatch/FilterManager"));
    private Hashtable<String, FilterConfigImpl> _filters = new Hashtable();
    private Hashtable<String, Filter> _instances = new Hashtable();

    public void addFilter(FilterConfigImpl config) {
        if (config.getServletContext() == null) {
            throw new NullPointerException();
        }
        this._filters.put(config.getFilterName(), config);
    }

    public FilterConfigImpl getFilter(String filterName) {
        return this._filters.get(filterName);
    }

    public void init() {
    }

    public Filter createFilter(String filterName) throws ServletException {
        FilterConfigImpl config = this._filters.get(filterName);
        if (config == null) {
            throw new ServletException(L.l("`{0}' is not a known filter.  Filters must be defined by <filter> before being used.", filterName));
        }
        Class filterClass = config.getFilterClass();
        FilterConfigImpl filterConfigImpl = config;
        synchronized (filterConfigImpl) {
            try {
                Filter filter = this._instances.get(filterName);
                if (filter != null) {
                    return filter;
                }
                filter = (Filter)filterClass.newInstance();
                InjectIntrospector.configure(filter);
                InitProgram init = config.getInit();
                if (init != null) {
                    init.getBuilderProgram().configure(filter);
                }
                filter.init(config);
                this._instances.put(filterName, filter);
                return filter;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (this._instances != null) {
            Hashtable<String, Filter> hashtable = this._instances;
            synchronized (hashtable) {
                Enumeration<Filter> en = this._instances.elements();
                while (en.hasMoreElements()) {
                    Filter filter = en.nextElement();
                    filterList.add(filter);
                }
            }
        }
        for (int i = 0; i < filterList.size(); ++i) {
            Filter filter = (Filter)filterList.get(i);
            try {
                filter.destroy();
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }
}

