/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.log.Log;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrecompilePageFilterChain
implements FilterChain {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/dispatch/PageFilterChain"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/dispatch/PageFilterChain"));
    private QServlet _servlet;
    private ServletContext _servletContext;

    PrecompilePageFilterChain(QServlet servlet) {
        this._servlet = servlet;
    }

    static FilterChain create(ServletInvocation invocation, PageFilterChain pageChain) {
        String query = invocation.getQueryString();
        if (query == null) {
            return pageChain;
        }
        int p = query.indexOf("jsp_precompile");
        if (p < 0) {
            return pageChain;
        }
        String tail = query.substring(p + "jsp_precompile".length());
        if (tail.startsWith("=\"true\"") || !tail.startsWith("=")) {
            return new PrecompilePageFilterChain(pageChain.getServlet());
        }
        return pageChain;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            Page page = this._servlet.getPage(req, res);
            if (page == null) {
                res.sendError(404);
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw new ServletException(e);
        }
        PrintWriter out = res.getWriter();
        out.println("Precompiled page.");
    }
}

