/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.ServletConfigImpl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class ServletFilterChain
implements FilterChain {
    public static String SERVLET_NAME = "javax.servlet.error.servlet_name";
    private ServletConfigImpl _config;
    private Servlet _servlet;

    public ServletFilterChain(ServletConfigImpl config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._config = config;
    }

    public String getServletName() {
        return this._config.getServletName();
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._servlet == null) {
            try {
                this._servlet = this._config.createServlet();
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
        try {
            this._servlet.service(request, response);
        }
        catch (UnavailableException e) {
            this._servlet = null;
            this._config.setInitException(e);
            this._config.killServlet();
            request.setAttribute(SERVLET_NAME, this._config.getServletName());
            throw e;
        }
        catch (ServletException e) {
            request.setAttribute(SERVLET_NAME, this._config.getServletName());
            throw e;
        }
        catch (IOException e) {
            request.setAttribute(SERVLET_NAME, this._config.getServletName());
            throw e;
        }
    }
}

