/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.log.Log;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.PrecompilePageFilterChain;
import com.caucho.server.dispatch.RedirectFilterChain;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMapper {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/dispatch/ServletMapper"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/dispatch/ServletMapper"));
    private ServletContext _servletContext;
    private ServletManager _servletManager;
    private UrlMap<String> _servletMap = new UrlMap();
    private ArrayList<String> _welcomeFileList = new ArrayList();
    private HashMap<String, ServletMapping> _regexpMap = new HashMap();
    private ArrayList<String> _ignorePatterns = new ArrayList();
    private String _defaultServlet;

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void addServletMapping(ServletMapping mapping) throws ServletException {
        try {
            if (mapping.getURLRegexp() != null) {
                String regexp = mapping.getURLRegexp();
                this._servletMap.addRegexp(regexp, regexp);
                this._regexpMap.put(regexp, mapping);
                return;
            }
            String servletName = mapping.getServletName();
            if (servletName == null) {
                servletName = mapping.getServletClassName();
            }
            if (servletName == null) {
                throw new ServletConfigException(L.l("servlet needs a servlet-name."));
            }
            if (!servletName.equals("invoker") && !servletName.equals("plugin_match")) {
                if (servletName.equals("plugin_ignore")) {
                    if (mapping.getURLPattern() != null) {
                        this._ignorePatterns.add(mapping.getURLPattern());
                    }
                    return;
                }
                if (this._servletManager.getServlet(servletName) == null) {
                    throw new ServletConfigException(L.l("`{0}' is an unknown servlet-name.  servlet-mapping requires that the named servlet be defined in a <servlet> configuration before the <servlet-mapping>.", servletName));
                }
            }
            if ("/".equals(mapping.getURLPattern())) {
                this._defaultServlet = servletName;
            } else if (mapping.isStrictMapping()) {
                this._servletMap.addStrictMap(mapping.getURLPattern(), null, servletName);
            } else {
                this._servletMap.addMap(mapping.getURLPattern(), servletName);
            }
            log.config(new StringBuffer().append("servlet-mapping ").append(mapping.getURLPattern()).append(" -> ").append(servletName).toString());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void addServletRegexp(ServletMapping servletRegexp) throws ServletException {
        try {
            String regexp = servletRegexp.getURLRegexp();
            this._servletMap.addRegexp(regexp, regexp);
            this._regexpMap.put(regexp, servletRegexp);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void setDefaultServlet(String servletName) throws ServletException {
        this._defaultServlet = servletName;
    }

    public void addWelcomeFile(String fileName) {
        this._welcomeFileList.add(fileName);
    }

    public void setWelcomeFileList(ArrayList<String> list) {
        this._welcomeFileList.clear();
        this._welcomeFileList.addAll(list);
    }

    public FilterChain mapServlet(ServletInvocation invocation) throws ServletException {
        FilterChain chain;
        ServletMapping servletRegexp;
        String contextURI = invocation.getContextURI();
        String servletName = null;
        ArrayList<String> vars = new ArrayList<String>();
        invocation.setClassLoader(Thread.currentThread().getContextClassLoader());
        if (this._servletMap != null && (servletRegexp = this._regexpMap.get(servletName = this._servletMap.map(contextURI, vars))) != null) {
            servletName = servletRegexp.initRegexp(this._servletContext, this._servletManager, vars);
        }
        if (servletName == null) {
            try {
                InputStream is = this._servletContext.getResourceAsStream(contextURI);
                if (is != null) {
                    is.close();
                    servletName = this._defaultServlet;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (servletName == null) {
            for (int i = 0; i < this._welcomeFileList.size(); ++i) {
                String file = this._welcomeFileList.get(i);
                try {
                    InputStream is = this._servletContext.getResourceAsStream(new StringBuffer().append(contextURI).append("/").append(file).toString());
                    if (is != null) {
                        is.close();
                    }
                    if (is == null) continue;
                    if (!contextURI.endsWith("/")) {
                        String contextPath = invocation.getContextPath();
                        String queryString = invocation.getQueryString();
                        if (queryString != null) {
                            return new RedirectFilterChain(new StringBuffer().append(contextPath).append(contextURI).append("/?").append(queryString).toString());
                        }
                        return new RedirectFilterChain(new StringBuffer().append(contextPath).append(contextURI).append("/").toString());
                    }
                    String uri = new StringBuffer().append(contextURI).append(file).toString();
                    servletName = this._servletMap.map(uri, vars);
                    if (servletName == null && this._defaultServlet == null) continue;
                    contextURI = uri;
                    if (!(invocation instanceof Invocation)) break;
                    Invocation inv = (Invocation)invocation;
                    inv.setContextURI(contextURI);
                    inv.setRawURI(new StringBuffer().append(inv.getRawURI()).append(file).toString());
                    break;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (servletName == null) {
            servletName = this._defaultServlet;
            vars.clear();
            vars.add(contextURI);
        }
        if (servletName == null) {
            log.fine(L.l("no default servlet defined for URL: '{0}'", contextURI));
            return new ErrorFilterChain(404);
        }
        String servletPath = vars.get(0);
        invocation.setServletPath(servletPath);
        if (servletPath.length() < contextURI.length()) {
            invocation.setPathInfo(contextURI.substring(servletPath.length()));
        } else {
            invocation.setPathInfo(null);
        }
        ServletMapping regexp = this._regexpMap.get(servletName);
        if (servletName.equals("invoker")) {
            servletName = this.handleInvoker(invocation);
        }
        invocation.setServletName(servletName);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("invoke (uri:").append(contextURI).append(" -> ").append(servletName).append(")").toString());
        }
        if ((chain = this._servletManager.createServletChain(servletName)) instanceof PageFilterChain) {
            PageFilterChain pageChain = (PageFilterChain)chain;
            return PrecompilePageFilterChain.create(invocation, pageChain);
        }
        return chain;
    }

    private String handleInvoker(ServletInvocation invocation) throws ServletException {
        String tail = invocation.getPathInfo() != null ? invocation.getPathInfo() : invocation.getServletPath();
        if (!tail.startsWith("/")) {
            throw new ServletException(new StringBuffer().append("expected '/' starting  sp:").append(invocation.getServletPath()).append(" pi:").append(invocation.getPathInfo()).append(" sn:invocation").append(invocation).toString());
        }
        int next = tail.indexOf(47, 1);
        String servletName = next < 0 ? tail.substring(1) : tail.substring(1, next);
        if (servletName.startsWith("com.caucho")) {
            throw new ServletConfigException(L.l("servlet `{0}' forbidden from invoker. com.caucho.* classes must be defined explicitly in a <servlet> declaration.", servletName));
        }
        if (servletName.equals("")) {
            throw new ServletConfigException(L.l("invoker needs a servlet name in URL `{0}'.", invocation.getContextURI()));
        }
        this.addServlet(servletName);
        String servletPath = invocation.getServletPath();
        if (invocation.getPathInfo() != null) {
            if (next < 0) {
                invocation.setServletPath(new StringBuffer().append(servletPath).append(tail).toString());
                invocation.setPathInfo(null);
            } else if (next < tail.length()) {
                invocation.setServletPath(new StringBuffer().append(servletPath).append(tail.substring(0, next)).toString());
                invocation.setPathInfo(tail.substring(next));
            } else {
                invocation.setServletPath(new StringBuffer().append(servletPath).append(tail).toString());
                invocation.setPathInfo(null);
            }
        }
        return servletName;
    }

    public String getServletPattern(String uri) {
        ArrayList<String> vars = new ArrayList<String>();
        String value = null;
        if (this._servletMap != null) {
            value = this._servletMap.map(uri, vars);
        }
        if (value == null) {
            return null;
        }
        return uri;
    }

    public ArrayList<String> getURLPatterns() {
        return this._servletMap.getURLPatterns();
    }

    public ArrayList<String> getIgnorePatterns() {
        return this._ignorePatterns;
    }

    private void addServlet(String servletName) throws ServletException {
        if (this._servletManager.getServlet(servletName) != null) {
            return;
        }
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this._servletContext);
        config.setServletName(servletName);
        try {
            config.setServletClass(servletName);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        config.init();
        this._servletManager.addServlet(config);
    }

    public void destroy() {
        this._servletManager.destroy();
    }
}

